/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.runtime.customized;

import io.vertx.sqlclient.Pool;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.pool.impl.SqlClientPool;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class QuarkusSqlClientPool
extends SqlClientPool
implements ServiceRegistryAwareService {
    private final Pool pool;
    private SqlStatementLogger sqlStatementLogger;
    private SqlExceptionHelper sqlExceptionHelper;
    private ServiceRegistryImplementor serviceRegistry;

    public QuarkusSqlClientPool(Pool pool) {
        this.pool = pool;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.sqlStatementLogger = (SqlStatementLogger)serviceRegistry.getService(SqlStatementLogger.class);
    }

    protected Pool getPool() {
        return this.pool;
    }

    protected SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    public SqlExceptionHelper getSqlExceptionHelper() {
        if (this.sqlExceptionHelper == null) {
            this.sqlExceptionHelper = ((JdbcServices)this.serviceRegistry.getService(JdbcServices.class)).getSqlExceptionHelper();
        }
        return this.sqlExceptionHelper;
    }

    public CompletionStage<Void> getCloseFuture() {
        return CompletionStages.voidFuture();
    }
}

