/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.backend.elasticsearch.common.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.search.backend.elasticsearch.common.deployment.HibernateSearchBackendElasticsearchEnabledBuildItem;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.MapperContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonClasses;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;

@BuildSteps
class HibernateSearchBackendElasticsearchProcessor {
    HibernateSearchBackendElasticsearchProcessor() {
    }

    @BuildStep
    void registerBeans(List<HibernateSearchBackendElasticsearchEnabledBuildItem> enabled, BuildProducer<UnremovableBeanBuildItem> unremovableBean) {
        if (enabled.isEmpty()) {
            return;
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ElasticsearchAnalysisConfigurer.class, IndexLayoutStrategy.class}));
    }

    @BuildStep
    void registerReflectionForGson(List<HibernateSearchBackendElasticsearchEnabledBuildItem> enabled, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (enabled.isEmpty()) {
            return;
        }
        String[] reflectiveClasses = (String[])GsonClasses.typesRequiringReflection().toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])reflectiveClasses).reason(this.getClass().getName()).methods().fields().build());
    }

    @BuildStep
    void processBuildTimeConfig(List<HibernateSearchBackendElasticsearchEnabledBuildItem> enabled, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (enabled.isEmpty()) {
            return;
        }
        for (HibernateSearchBackendElasticsearchEnabledBuildItem enabledItem : enabled) {
            this.processBuildTimeConfig(enabledItem, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private void processBuildTimeConfig(HibernateSearchBackendElasticsearchEnabledBuildItem enabled, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        LinkedHashSet<String> propertyKeysWithNoVersion = new LinkedHashSet<String>();
        Map<String, HibernateSearchBackendElasticsearchBuildTimeConfig> buildTimeConfig = enabled.getBuildTimeConfig();
        MapperContext mapperContext = enabled.getMapperContext();
        LinkedHashSet<String> allBackendNames = new LinkedHashSet<String>(mapperContext.getBackendNamesForIndexedEntities());
        allBackendNames.addAll(buildTimeConfig.keySet());
        for (String backendName : allBackendNames) {
            HibernateSearchBackendElasticsearchBuildTimeConfig backendConfig = buildTimeConfig.get(backendName);
            if (backendConfig == null || backendConfig.version().isEmpty()) {
                propertyKeysWithNoVersion.add(mapperContext.backendPropertyKey(backendName, null, "version"));
            }
            if (backendConfig == null) continue;
            HibernateSearchBackendElasticsearchProcessor.registerClasspathFilesFromBackendConfig(mapperContext, backendName, backendConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
        if (!propertyKeysWithNoVersion.isEmpty()) {
            throw new ConfigurationException("The Elasticsearch version needs to be defined via properties: " + String.join((CharSequence)", ", propertyKeysWithNoVersion) + ".", propertyKeysWithNoVersion);
        }
    }

    private static void registerClasspathFilesFromBackendConfig(MapperContext mapperContext, String backendName, HibernateSearchBackendElasticsearchBuildTimeConfig backendConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchBackendElasticsearchProcessor.registerClasspathFilesFromIndexConfig(mapperContext, backendName, null, backendConfig.indexDefaults(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        for (Map.Entry entry : backendConfig.indexes().entrySet()) {
            String indexName = (String)entry.getKey();
            HibernateSearchBackendElasticsearchBuildTimeConfig.IndexConfig indexConfig = (HibernateSearchBackendElasticsearchBuildTimeConfig.IndexConfig)entry.getValue();
            HibernateSearchBackendElasticsearchProcessor.registerClasspathFilesFromIndexConfig(mapperContext, backendName, indexName, indexConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private static void registerClasspathFilesFromIndexConfig(MapperContext mapperContext, String backendName, String indexName, HibernateSearchBackendElasticsearchBuildTimeConfig.IndexConfig indexConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchBackendElasticsearchProcessor.registerClasspathFileFromConfig(mapperContext, backendName, indexName, "schema-management.settings-file", indexConfig.schemaManagement().settingsFile(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        HibernateSearchBackendElasticsearchProcessor.registerClasspathFileFromConfig(mapperContext, backendName, indexName, "schema-management.mapping-file", indexConfig.schemaManagement().mappingFile(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
    }

    private static void registerClasspathFileFromConfig(MapperContext mapperContext, String backendName, String indexName, String propertyKeyRadical, Optional<String> classpathFileOptional, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (!classpathFileOptional.isPresent()) {
            return;
        }
        String classpathFile = classpathFileOptional.get();
        Path existingPath = applicationArchivesBuildItem.getRootArchive().getChildPath(classpathFile);
        if (existingPath == null || Files.isDirectory(existingPath, new LinkOption[0])) {
            throw new ConfigurationException("Unable to find file referenced in '" + mapperContext.backendPropertyKey(backendName, indexName, propertyKeyRadical) + "=" + classpathFile + "'. Remove property or add file to your path.");
        }
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{classpathFile}));
        hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(classpathFile));
    }
}

