/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.backend.elasticsearch.common.runtime;

import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.MapperContext;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;

public final class HibernateSearchBackendElasticsearchConfigHandler {
    public static void contributeBackendBuildTimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, Map<String, HibernateSearchBackendElasticsearchBuildTimeConfig> backendConfigs) {
        LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
        HibernateSearchConfigUtil.mergeInto(backendAndIndexNames, mapperContext.getBackendAndIndexNamesForSearchExtensions());
        for (Map.Entry<String, HibernateSearchBackendElasticsearchBuildTimeConfig> entry : backendConfigs.entrySet()) {
            HibernateSearchConfigUtil.mergeInto(backendAndIndexNames, entry.getKey(), entry.getValue().indexes().keySet());
        }
        for (Map.Entry<String, HibernateSearchBackendElasticsearchBuildTimeConfig> entry : backendAndIndexNames.entrySet()) {
            String backendName = entry.getKey();
            Set indexNames = (Set)((Object)entry.getValue());
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendBuildTimeProperties(propertyCollector, mapperContext, backendName, indexNames, backendConfigs.get(backendName));
        }
    }

    private static void contributeBackendBuildTimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, String backendName, Set<String> indexNames, HibernateSearchBackendElasticsearchBuildTimeConfig elasticsearchBackendConfig) {
        HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "type", "elasticsearch");
        if (elasticsearchBackendConfig != null) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version", elasticsearchBackendConfig.version());
        }
        HibernateSearchBackendElasticsearchConfigHandler.contributeBackendIndexBuildTimeProperties(propertyCollector, mapperContext, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
        for (String indexName : indexNames) {
            HibernateSearchBackendElasticsearchBuildTimeConfig.IndexConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendIndexBuildTimeProperties(propertyCollector, mapperContext, backendName, indexName, indexConfig);
        }
    }

    private static void contributeBackendIndexBuildTimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, String backendName, String indexName, HibernateSearchBackendElasticsearchBuildTimeConfig.IndexConfig indexConfig) {
        if (indexConfig != null) {
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.settings_file", indexConfig.schemaManagement().settingsFile());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.mapping_file", indexConfig.schemaManagement().mappingFile());
        }
        HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "analysis.configurer", mapperContext.multiExtensionBeanReferencesFor(indexConfig == null ? Optional.empty() : indexConfig.analysis().configurer(), ElasticsearchAnalysisConfigurer.class, backendName, indexName));
    }

    public static void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, Map<String, HibernateSearchBackendElasticsearchRuntimeConfig> backendConfigs) {
        LinkedHashMap<String, Set<String>> backendAndIndexNames = new LinkedHashMap<String, Set<String>>();
        HibernateSearchConfigUtil.mergeInto(backendAndIndexNames, mapperContext.getBackendAndIndexNamesForSearchExtensions());
        for (Map.Entry<String, HibernateSearchBackendElasticsearchRuntimeConfig> entry : backendConfigs.entrySet()) {
            HibernateSearchConfigUtil.mergeInto(backendAndIndexNames, entry.getKey(), entry.getValue().indexes().keySet());
        }
        for (Map.Entry<String, HibernateSearchBackendElasticsearchRuntimeConfig> entry : backendAndIndexNames.entrySet()) {
            String backendName = entry.getKey();
            Set indexNames = (Set)((Object)entry.getValue());
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendRuntimeProperties(propertyCollector, mapperContext, backendName, indexNames, backendConfigs.get(backendName));
        }
    }

    private static void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, String backendName, Set<String> indexNames, HibernateSearchBackendElasticsearchRuntimeConfig elasticsearchBackendConfig) {
        if (elasticsearchBackendConfig != null) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "hosts", elasticsearchBackendConfig.hosts());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "protocol", elasticsearchBackendConfig.protocol().getHibernateSearchString());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "username", elasticsearchBackendConfig.username());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "password", elasticsearchBackendConfig.password());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "connection_timeout", elasticsearchBackendConfig.connectionTimeout().toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "read_timeout", elasticsearchBackendConfig.readTimeout().toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "request_timeout", elasticsearchBackendConfig.requestTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections", elasticsearchBackendConfig.maxConnections());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections_per_route", elasticsearchBackendConfig.maxConnectionsPerRoute());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "thread_pool.size", elasticsearchBackendConfig.threadPool().size());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version_check.enabled", elasticsearchBackendConfig.versionCheck().enabled());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "query.shard_failure.ignore", elasticsearchBackendConfig.query().shardFailure().ignore());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.enabled", elasticsearchBackendConfig.discovery().enabled());
            if (elasticsearchBackendConfig.discovery().enabled().booleanValue()) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.refresh_interval", elasticsearchBackendConfig.discovery().refreshInterval().getSeconds());
            }
        }
        HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "layout.strategy", mapperContext.singleExtensionBeanReferenceFor(elasticsearchBackendConfig == null ? Optional.empty() : elasticsearchBackendConfig.layout().strategy(), IndexLayoutStrategy.class, backendName, null));
        HibernateSearchBackendElasticsearchConfigHandler.contributeBackendIndexRuntimeProperties(propertyCollector, mapperContext, backendName, null, elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexDefaults());
        for (String indexName : indexNames) {
            HibernateSearchBackendElasticsearchRuntimeConfig.IndexConfig indexConfig = elasticsearchBackendConfig == null ? null : elasticsearchBackendConfig.indexes().get(indexName);
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendIndexRuntimeProperties(propertyCollector, mapperContext, backendName, indexName, indexConfig);
        }
    }

    private static void contributeBackendIndexRuntimeProperties(BiConsumer<String, Object> propertyCollector, MapperContext mapperContext, String backendName, String indexName, HibernateSearchBackendElasticsearchRuntimeConfig.IndexConfig indexConfig) {
        if (indexConfig != null) {
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status", indexConfig.schemaManagement().requiredStatus());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status_wait_timeout", indexConfig.schemaManagement().requiredStatusWaitTimeout(), Optional::isPresent, d -> ((Duration)d.get()).toMillis());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_count", indexConfig.indexing().queueCount());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_size", indexConfig.indexing().queueSize());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.max_bulk_size", indexConfig.indexing().maxBulkSize());
        }
    }
}

