/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchClasses;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.UnresolvedTypeVariable;
import org.jboss.jandex.VoidType;

class HibernateSearchElasticsearchProcessor {
    private static final String HIBERNATE_SEARCH_ELASTICSEARCH = "Hibernate Search Elasticsearch";
    HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig;

    HibernateSearchElasticsearchProcessor() {
    }

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchIntegrator", new String[]{"HSEARCH000034"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HibernateOrmIntegrationBuildItem> integrations, BuildProducer<FeatureBuildItem> feature) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_SEARCH_ELASTICSEARCH));
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(HibernateSearchClasses.INDEXED);
        if (indexedAnnotations.isEmpty()) {
            return;
        }
        boolean defaultBackendIsUsed = false;
        for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
            if (indexedAnnotation.value("backend") != null) continue;
            defaultBackendIsUsed = true;
            break;
        }
        HibernateSearchElasticsearchProcessor.checkConfig(this.buildTimeConfig, defaultBackendIsUsed);
        integrations.produce((BuildItem)new HibernateOrmIntegrationBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH));
        this.registerReflection(index, reflectiveClass);
        recorder.registerHibernateSearchIntegration(this.buildTimeConfig);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        recorder.setRuntimeConfig(runtimeConfig);
        runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH));
    }

    private static void checkConfig(HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig, boolean defaultBackendIsUsed) {
        if (defaultBackendIsUsed && !buildTimeConfig.defaultBackend.version.isPresent()) {
            throw new ConfigurationError("The Elasticsearch version needs to be defined via the quarkus.hibernate-search-orm.elasticsearch.version property.");
        }
        ArrayList namedBackendsWithNoVersion = new ArrayList();
        for (Map.Entry additionalBackendEntry : buildTimeConfig.namedBackends.backends.entrySet()) {
            if (((HibernateSearchElasticsearchBuildTimeConfig.ElasticsearchBackendBuildTimeConfig)additionalBackendEntry.getValue()).version.isPresent()) continue;
            namedBackendsWithNoVersion.add(additionalBackendEntry.getKey());
        }
        if (!namedBackendsWithNoVersion.isEmpty()) {
            throw new ConfigurationError("The Elasticsearch version property needs to be defined for backends " + String.join((CharSequence)", ", namedBackendsWithNoVersion));
        }
    }

    private void registerReflection(IndexView index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        HashSet<DotName> reflectiveClassCollector = new HashSet<DotName>();
        if (this.buildTimeConfig.defaultBackend.indexDefaults.analysis.configurer.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{(Class)this.buildTimeConfig.defaultBackend.indexDefaults.analysis.configurer.get()}));
        }
        for (HibernateSearchElasticsearchBuildTimeConfig.ElasticsearchIndexBuildTimeConfig indexConfig : this.buildTimeConfig.defaultBackend.indexes.values()) {
            if (!indexConfig.analysis.configurer.isPresent()) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{(Class)indexConfig.analysis.configurer.get()}));
        }
        if (this.buildTimeConfig.defaultBackend.layout.strategy.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{(Class)this.buildTimeConfig.defaultBackend.layout.strategy.get()}));
        }
        if (this.buildTimeConfig.backgroundFailureHandler.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new Class[]{(Class)this.buildTimeConfig.backgroundFailureHandler.get()}));
        }
        for (AnnotationInstance propertyMappingMetaAnnotationInstance : index.getAnnotations(HibernateSearchClasses.PROPERTY_MAPPING_META_ANNOTATION)) {
            for (AnnotationInstance propertyMappingAnnotationInstance : index.getAnnotations(propertyMappingMetaAnnotationInstance.name())) {
                AnnotationTarget annotationTarget = propertyMappingAnnotationInstance.target();
                if (annotationTarget.kind() == AnnotationTarget.Kind.FIELD) {
                    FieldInfo fieldInfo = annotationTarget.asField();
                    HibernateSearchElasticsearchProcessor.addReflectiveClass(index, reflectiveClassCollector, fieldInfo.declaringClass());
                    HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, fieldInfo.type());
                    continue;
                }
                if (annotationTarget.kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo methodInfo = annotationTarget.asMethod();
                HibernateSearchElasticsearchProcessor.addReflectiveClass(index, reflectiveClassCollector, methodInfo.declaringClass());
                HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, methodInfo.returnType());
            }
        }
        for (AnnotationInstance typeBridgeMappingInstance : index.getAnnotations(HibernateSearchClasses.TYPE_MAPPING_META_ANNOTATION)) {
            for (AnnotationInstance typeBridgeInstance : index.getAnnotations(typeBridgeMappingInstance.name())) {
                HibernateSearchElasticsearchProcessor.addReflectiveClass(index, reflectiveClassCollector, typeBridgeInstance.target().asClass());
            }
        }
        reflectiveClassCollector.addAll(HibernateSearchClasses.GSON_CLASSES);
        String[] reflectiveClasses = (String[])reflectiveClassCollector.stream().map(DotName::toString).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, reflectiveClasses));
    }

    private static void addReflectiveClass(IndexView index, Set<DotName> reflectiveClassCollector, ClassInfo classInfo) {
        if (HibernateSearchElasticsearchProcessor.skipClass(classInfo.name(), reflectiveClassCollector)) {
            return;
        }
        reflectiveClassCollector.add(classInfo.name());
        for (ClassInfo subclass : index.getAllKnownSubclasses(classInfo.name())) {
            reflectiveClassCollector.add(subclass.name());
        }
        for (ClassInfo implementor : index.getAllKnownImplementors(classInfo.name())) {
            reflectiveClassCollector.add(implementor.name());
        }
        Type superClassType = classInfo.superClassType();
        while (superClassType != null && !superClassType.name().toString().equals("java.lang.Object")) {
            reflectiveClassCollector.add(superClassType.name());
            if (superClassType instanceof ClassType) {
                superClassType = index.getClassByName(superClassType.name()).superClassType();
                continue;
            }
            if (!(superClassType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = superClassType.asParameterizedType();
            for (Type typeArgument : parameterizedType.arguments()) {
                HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, typeArgument);
            }
            superClassType = parameterizedType.owner();
        }
    }

    private static void addReflectiveType(IndexView index, Set<DotName> reflectiveClassCollector, Type type) {
        if (type instanceof VoidType || type instanceof PrimitiveType || type instanceof UnresolvedTypeVariable) {
            return;
        }
        if (type instanceof ClassType) {
            ClassInfo classInfo = index.getClassByName(type.name());
            HibernateSearchElasticsearchProcessor.addReflectiveClass(index, reflectiveClassCollector, classInfo);
        } else if (type instanceof ArrayType) {
            HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, type.asArrayType().component());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, parameterizedType.owner());
            for (Type typeArgument : parameterizedType.arguments()) {
                HibernateSearchElasticsearchProcessor.addReflectiveType(index, reflectiveClassCollector, typeArgument);
            }
        }
    }

    private static boolean skipClass(DotName name, Set<DotName> processedClasses) {
        return name.toString().startsWith("java.") || processedClasses.contains(name);
    }
}

