/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchClasses;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.ElasticsearchVersionSubstitution;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonClasses;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.IndexView;

class HibernateSearchElasticsearchProcessor {
    private static final String HIBERNATE_SEARCH_ELASTICSEARCH = "Hibernate Search ORM + Elasticsearch";
    HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig;

    HibernateSearchElasticsearchProcessor() {
    }

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService", new String[]{"HSEARCH000034"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations, BuildProducer<FeatureBuildItem> feature, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_SEARCH_ELASTICSEARCH));
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(HibernateSearchClasses.INDEXED);
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            ArrayList<AnnotationInstance> indexedAnnotationsForPU = new ArrayList<AnnotationInstance>();
            for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
                String targetName = indexedAnnotation.target().asClass().name().toString();
                if (!puDescriptor.getManagedClassNames().contains(targetName)) continue;
                indexedAnnotationsForPU.add(indexedAnnotation);
            }
            this.buildForPersistenceUnit(recorder, indexedAnnotationsForPU, puDescriptor.getPersistenceUnitName(), configuredPersistenceUnits, staticIntegrations, runtimeIntegrations);
        }
        this.registerReflectionForGson(reflectiveClass);
    }

    private void buildForPersistenceUnit(HibernateSearchElasticsearchRecorder recorder, Collection<AnnotationInstance> indexedAnnotationsForPU, String persistenceUnitName, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations) {
        if (indexedAnnotationsForPU.isEmpty()) {
            staticIntegrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createDisabledStaticInitListener()));
            runtimeIntegrations.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createDisabledRuntimeInitListener()));
            return;
        }
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit puConfig = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName) ? this.buildTimeConfig.defaultPersistenceUnit : (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit)this.buildTimeConfig.persistenceUnits.get(persistenceUnitName);
        boolean defaultBackendIsUsed = false;
        for (AnnotationInstance indexedAnnotation : indexedAnnotationsForPU) {
            if (indexedAnnotation.value("backend") != null) continue;
            defaultBackendIsUsed = true;
            break;
        }
        configuredPersistenceUnits.produce((BuildItem)new HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem(persistenceUnitName, puConfig, defaultBackendIsUsed));
    }

    @BuildStep
    void registerBeans(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> searchEnabledPUs, BuildProducer<UnremovableBeanBuildItem> unremovableBean) {
        if (searchEnabledPUs.isEmpty()) {
            return;
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{FailureHandler.class, AutomaticIndexingSynchronizationStrategy.class, ElasticsearchAnalysisConfigurer.class, IndexLayoutStrategy.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setStaticConfig(RecorderContext recorderContext, HibernateSearchElasticsearchRecorder recorder, List<HibernateSearchIntegrationStaticConfiguredBuildItem> integrationStaticConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticConfigured) {
        recorderContext.registerSubstitution(ElasticsearchVersion.class, String.class, ElasticsearchVersionSubstitution.class);
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners = new ArrayList<HibernateOrmIntegrationStaticInitListener>();
            boolean xmlMappingRequired = false;
            for (HibernateSearchIntegrationStaticConfiguredBuildItem item : integrationStaticConfigBuildItems) {
                HibernateOrmIntegrationStaticInitListener listener;
                if (item.getPersistenceUnitName().equals(puName) && (listener = item.getInitListener()) != null) {
                    integrationStaticInitListeners.add(listener);
                }
                if (!item.isXmlMappingRequired()) continue;
                xmlMappingRequired = true;
            }
            staticConfigured.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createStaticInitListener(configuredPersistenceUnit.getBuildTimeConfig(), integrationStaticInitListeners)).setXmlMappingRequired(xmlMappingRequired));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<HibernateSearchIntegrationRuntimeConfiguredBuildItem> integrationRuntimeConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners = new ArrayList<HibernateOrmIntegrationRuntimeInitListener>();
            for (HibernateSearchIntegrationRuntimeConfiguredBuildItem item : integrationRuntimeConfigBuildItems) {
                HibernateOrmIntegrationRuntimeInitListener listener;
                if (!item.getPersistenceUnitName().equals(puName) || (listener = item.getInitListener()) == null) continue;
                integrationRuntimeInitListeners.add(listener);
            }
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createRuntimeInitListener(runtimeConfig, puName, integrationRuntimeInitListeners)));
        }
    }

    @BuildStep
    public void processPersistenceUnitBuildTimeConfig(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            this.processPersistenceUnitBuildTimeConfig(configuredPersistenceUnit, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private void processPersistenceUnitBuildTimeConfig(HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        String persistenceUnitName = configuredPersistenceUnit.getPersistenceUnitName();
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig = configuredPersistenceUnit.getBuildTimeConfig();
        LinkedHashSet<String> propertyKeysWithNoVersion = new LinkedHashSet<String>();
        if (configuredPersistenceUnit.isDefaultBackendUsed()) {
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig backendConfig;
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig elasticsearchBackendBuildTimeConfig = backendConfig = buildTimeConfig != null ? buildTimeConfig.defaultBackend : null;
            if (backendConfig == null || !backendConfig.version.isPresent()) {
                propertyKeysWithNoVersion.add(HibernateSearchElasticsearchProcessor.elasticsearchVersionPropertyKey(persistenceUnitName, null));
            }
            if (backendConfig != null) {
                HibernateSearchElasticsearchProcessor.registerClasspathFileFromBackendConfig(persistenceUnitName, null, backendConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
            }
        }
        Map backends = buildTimeConfig != null ? buildTimeConfig.namedBackends.backends : Collections.emptyMap();
        for (Map.Entry additionalBackendEntry : backends.entrySet()) {
            String backendName = (String)additionalBackendEntry.getKey();
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig backendConfig = (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig)additionalBackendEntry.getValue();
            if (!backendConfig.version.isPresent()) {
                propertyKeysWithNoVersion.add(HibernateSearchElasticsearchProcessor.elasticsearchVersionPropertyKey(persistenceUnitName, backendName));
            }
            HibernateSearchElasticsearchProcessor.registerClasspathFileFromBackendConfig(persistenceUnitName, backendName, backendConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
        if (!propertyKeysWithNoVersion.isEmpty()) {
            throw new ConfigurationException("The Elasticsearch version needs to be defined via properties: " + String.join((CharSequence)", ", propertyKeysWithNoVersion) + ".", propertyKeysWithNoVersion);
        }
    }

    private static void registerClasspathFileFromBackendConfig(String persistenceUnitName, String backendName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig backendConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromIndexConfig(persistenceUnitName, backendName, null, backendConfig.indexDefaults, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        for (Map.Entry entry : backendConfig.indexes.entrySet()) {
            String indexName = (String)entry.getKey();
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig = (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig)entry.getValue();
            HibernateSearchElasticsearchProcessor.registerClasspathFileFromIndexConfig(persistenceUnitName, backendName, indexName, indexConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private static void registerClasspathFileFromIndexConfig(String persistenceUnitName, String backendName, String indexName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromConfig(persistenceUnitName, backendName, indexName, "schema-management.settings-file", indexConfig.schemaManagement.settingsFile, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromConfig(persistenceUnitName, backendName, indexName, "schema-management.mapping-file", indexConfig.schemaManagement.mappingFile, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
    }

    private static void registerClasspathFileFromConfig(String persistenceUnitName, String backendName, String indexName, String propertyKeyRadical, Optional<String> classpathFileOptional, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (!classpathFileOptional.isPresent()) {
            return;
        }
        String classpathFile = classpathFileOptional.get();
        Path existingPath = applicationArchivesBuildItem.getRootArchive().getChildPath(classpathFile);
        if (existingPath == null || Files.isDirectory(existingPath, new LinkOption[0])) {
            throw new ConfigurationException("Unable to find file referenced in '" + HibernateSearchElasticsearchProcessor.backendPropertyKey(persistenceUnitName, backendName, indexName, propertyKeyRadical) + "=" + classpathFile + "'. Remove property or add file to your path.");
        }
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{classpathFile}));
        hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(classpathFile));
    }

    private static String elasticsearchVersionPropertyKey(String persistenceUnitName, String backendName) {
        return HibernateSearchElasticsearchProcessor.backendPropertyKey(persistenceUnitName, backendName, null, "version");
    }

    private static String backendPropertyKey(String persistenceUnitName, String backendName, String indexName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-orm.");
        if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            keyBuilder.append(persistenceUnitName).append(".");
        }
        keyBuilder.append("elasticsearch.");
        if (backendName != null) {
            keyBuilder.append(backendName).append(".");
        }
        if (indexName != null) {
            keyBuilder.append("indexes.").append(indexName).append(".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    private void registerReflectionForGson(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] reflectiveClasses = (String[])GsonClasses.typesRequiringReflection().toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, reflectiveClasses));
    }

    @BuildStep
    DevservicesElasticsearchBuildItem devServices(HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig) {
        if (buildTimeConfig.defaultPersistenceUnit != null && buildTimeConfig.defaultPersistenceUnit.defaultBackend != null && buildTimeConfig.defaultPersistenceUnit.defaultBackend.version.isPresent()) {
            ElasticsearchVersion version = (ElasticsearchVersion)buildTimeConfig.defaultPersistenceUnit.defaultBackend.version.get();
            return new DevservicesElasticsearchBuildItem("quarkus.hibernate-search-orm.elasticsearch.hosts", version.versionString(), DevservicesElasticsearchBuildItem.Distribution.valueOf((String)version.distribution().toString().toUpperCase()));
        }
        return null;
    }
}

