/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.session.SearchSession;

public class HibernateSearchElasticsearchCdiProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateSearchBeans(HibernateSearchElasticsearchRecorder recorder, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem persistenceUnit : configuredPersistenceUnits) {
            String persistenceUnitName = persistenceUnit.getPersistenceUnitName();
            boolean isDefaultPersistenceUnit = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName);
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateSearchElasticsearchCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPersistenceUnit, SearchMapping.class, recorder.searchMappingSupplier(persistenceUnitName, isDefaultPersistenceUnit)));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)HibernateSearchElasticsearchCdiProcessor.createSyntheticBean(persistenceUnitName, PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName), SearchSession.class, recorder.searchSessionSupplier(persistenceUnitName, isDefaultPersistenceUnit)));
        }
    }

    private static <T> SyntheticBeanBuildItem createSyntheticBean(String persistenceUnitName, boolean isDefaultPersistenceUnit, Class<T> type, Supplier<T> supplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(Singleton.class)).unremovable()).supplier(supplier);
        if (isDefaultPersistenceUnit) {
            configurator.addQualifier(Default.class);
        }
        configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitName).done();
        configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitName).done();
        return configurator.done();
    }
}

