/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchClasses;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.HibernateSearchIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.ElasticsearchVersionSubstitution;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class HibernateSearchElasticsearchProcessor {
    private static final String HIBERNATE_SEARCH_ELASTICSEARCH = "Hibernate Search ORM + Elasticsearch";
    HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig;

    HibernateSearchElasticsearchProcessor() {
    }

    @BuildStep
    void setupLogFilters(BuildProducer<LogCleanupFilterBuildItem> filters) {
        filters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchIntegrator", new String[]{"HSEARCH000034"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrations, BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_SEARCH_ELASTICSEARCH));
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(HibernateSearchClasses.INDEXED);
        recorderContext.registerSubstitution(ElasticsearchVersion.class, String.class, ElasticsearchVersionSubstitution.class);
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            ArrayList<AnnotationInstance> indexedAnnotationsForPU = new ArrayList<AnnotationInstance>();
            for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
                String targetName = indexedAnnotation.target().asClass().name().toString();
                if (!puDescriptor.getManagedClassNames().contains(targetName)) continue;
                indexedAnnotationsForPU.add(indexedAnnotation);
            }
            this.buildForPersistenceUnit(recorder, indexedAnnotationsForPU, puDescriptor.getPersistenceUnitName(), configuredPersistenceUnits, integrations);
        }
        this.registerReflectionForGson(reflectiveClass);
    }

    private void buildForPersistenceUnit(HibernateSearchElasticsearchRecorder recorder, Collection<AnnotationInstance> indexedAnnotationsForPU, String persistenceUnitName, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrations) {
        if (indexedAnnotationsForPU.isEmpty()) {
            integrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createDisabledListener()));
            return;
        }
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit puConfig = PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName) ? this.buildTimeConfig.defaultPersistenceUnit : (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit)this.buildTimeConfig.persistenceUnits.get(persistenceUnitName);
        boolean defaultBackendIsUsed = false;
        for (AnnotationInstance indexedAnnotation : indexedAnnotationsForPU) {
            if (indexedAnnotation.value("backend") != null) continue;
            defaultBackendIsUsed = true;
            break;
        }
        HibernateSearchElasticsearchProcessor.checkConfig(persistenceUnitName, puConfig, defaultBackendIsUsed);
        configuredPersistenceUnits.produce((BuildItem)new HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem(persistenceUnitName));
        if (puConfig == null) {
            return;
        }
        integrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createStaticInitListener(puConfig)));
    }

    @BuildStep
    void registerBeans(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> searchEnabledPUs, BuildProducer<UnremovableBeanBuildItem> unremovableBean) {
        if (searchEnabledPUs.isEmpty()) {
            return;
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{FailureHandler.class, AutomaticIndexingSynchronizationStrategy.class, ElasticsearchAnalysisConfigurer.class, IndexLayoutStrategy.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<HibernateSearchIntegrationRuntimeConfiguredBuildItem> integrationRuntimeConfigBuildItems, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners = new ArrayList<HibernateOrmIntegrationRuntimeInitListener>();
            for (HibernateSearchIntegrationRuntimeConfiguredBuildItem item : integrationRuntimeConfigBuildItems) {
                if (!item.getPersistenceUnitName().equals(puName)) continue;
                integrationRuntimeInitListeners.add(item.getInitListener());
            }
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createRuntimeInitListener(runtimeConfig, puDescriptor.getPersistenceUnitName(), integrationRuntimeInitListeners)));
        }
    }

    private static void checkConfig(String persistenceUnitName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig, boolean defaultBackendIsUsed) {
        ArrayList<String> propertyKeysWithNoVersion = new ArrayList<String>();
        if (defaultBackendIsUsed && (buildTimeConfig == null || !buildTimeConfig.defaultBackend.version.isPresent())) {
            propertyKeysWithNoVersion.add(HibernateSearchElasticsearchProcessor.elasticsearchVersionPropertyKey(persistenceUnitName, null));
        }
        Map backends = buildTimeConfig != null ? buildTimeConfig.namedBackends.backends : Collections.emptyMap();
        for (Map.Entry additionalBackendEntry : backends.entrySet()) {
            if (((HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig)additionalBackendEntry.getValue()).version.isPresent()) continue;
            propertyKeysWithNoVersion.add(HibernateSearchElasticsearchProcessor.elasticsearchVersionPropertyKey(persistenceUnitName, (String)additionalBackendEntry.getKey()));
        }
        if (!propertyKeysWithNoVersion.isEmpty()) {
            throw new ConfigurationError("The Elasticsearch version needs to be defined via properties: " + String.join((CharSequence)", ", propertyKeysWithNoVersion) + ".");
        }
    }

    private static String elasticsearchVersionPropertyKey(String persistenceUnitName, String backendName) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-orm.");
        if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            keyBuilder.append(persistenceUnitName).append(".");
        }
        keyBuilder.append("elasticsearch.");
        if (backendName != null) {
            keyBuilder.append(backendName).append(".");
        }
        keyBuilder.append("version");
        return keyBuilder.toString();
    }

    private void registerReflectionForGson(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] reflectiveClasses = (String[])HibernateSearchClasses.GSON_CLASSES.stream().map(DotName::toString).toArray(String[]::new);
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, reflectiveClasses));
    }
}

