/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.ClassNames;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.ElasticsearchVersionSubstitution;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRecorder;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonClasses;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateSearchEnabled.class})
class HibernateSearchElasticsearchProcessor {
    static final String HIBERNATE_SEARCH_ELASTICSEARCH = "Hibernate Search ORM + Elasticsearch";
    private static final Logger LOG = Logger.getLogger(HibernateSearchElasticsearchProcessor.class);
    HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig;

    HibernateSearchElasticsearchProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateSearchElasticsearchRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(ClassNames.INDEXED);
        Map<String, Map<String, Set<String>>> persistenceUnitAndBackendAndIndexNamesForSearchExtensions = HibernateSearchElasticsearchProcessor.collectPersistenceUnitAndBackendAndIndexNamesForSearchExtensions(index);
        Map configByPU = this.buildTimeConfig.getAllPersistenceUnitConfigsAsMap();
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            ArrayList<AnnotationInstance> indexedAnnotationsForPU = new ArrayList<AnnotationInstance>();
            for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
                String targetName = indexedAnnotation.target().asClass().name().toString();
                if (!puDescriptor.getManagedClassNames().contains(targetName)) continue;
                indexedAnnotationsForPU.add(indexedAnnotation);
            }
            Map<String, Set<String>> backendAndIndexNamesForSearchExtensions = persistenceUnitAndBackendAndIndexNamesForSearchExtensions.getOrDefault(puDescriptor.getPersistenceUnitName(), Collections.emptyMap());
            String puName = puDescriptor.getPersistenceUnitName();
            this.buildForPersistenceUnit(recorder, indexedAnnotationsForPU, puName, (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit)configByPU.get(puName), backendAndIndexNamesForSearchExtensions, configuredPersistenceUnits, staticIntegrations, runtimeIntegrations);
        }
        this.registerReflectionForGson(reflectiveClass);
    }

    private static Map<String, Map<String, Set<String>>> collectPersistenceUnitAndBackendAndIndexNamesForSearchExtensions(IndexView index) {
        LinkedHashMap<String, Map<String, Set<String>>> result = new LinkedHashMap<String, Map<String, Set<String>>>();
        for (AnnotationInstance annotation : index.getAnnotations(ClassNames.SEARCH_EXTENSION)) {
            AnnotationValue puName = annotation.value("persistenceUnit");
            AnnotationValue backendName = annotation.value("backend");
            AnnotationValue indexName = annotation.value("index");
            Set indexNames = result.computeIfAbsent(puName == null ? "<default>" : puName.asString(), ignored -> new LinkedHashMap()).computeIfAbsent(backendName == null ? null : backendName.asString(), ignored -> new LinkedHashSet());
            if (indexName == null) continue;
            indexNames.add(indexName.asString());
        }
        return result;
    }

    private void buildForPersistenceUnit(HibernateSearchElasticsearchRecorder recorder, Collection<AnnotationInstance> indexedAnnotationsForPU, String persistenceUnitName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit puConfig, Map<String, Set<String>> backendAndIndexNamesForSearchExtensions, BuildProducer<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticIntegrations, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeIntegrations) {
        if (indexedAnnotationsForPU.isEmpty()) {
            staticIntegrations.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createStaticInitInactiveListener()));
            runtimeIntegrations.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, persistenceUnitName).setInitListener(recorder.createRuntimeInitInactiveListener()));
            return;
        }
        LinkedHashSet<String> backendNamesForIndexedEntities = new LinkedHashSet<String>();
        for (AnnotationInstance indexedAnnotation : indexedAnnotationsForPU) {
            AnnotationValue backendNameValue = indexedAnnotation.value("backend");
            String backendName = backendNameValue == null ? null : backendNameValue.asString();
            backendNamesForIndexedEntities.add(backendName);
        }
        configuredPersistenceUnits.produce((BuildItem)new HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem(persistenceUnitName, puConfig, backendNamesForIndexedEntities, backendAndIndexNamesForSearchExtensions));
    }

    @BuildStep
    void registerBeans(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> searchEnabledPUs, BuildProducer<UnremovableBeanBuildItem> unremovableBean) {
        if (searchEnabledPUs.isEmpty()) {
            return;
        }
        unremovableBean.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{FailureHandler.class, AutomaticIndexingSynchronizationStrategy.class, ElasticsearchAnalysisConfigurer.class, IndexLayoutStrategy.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setStaticConfig(RecorderContext recorderContext, HibernateSearchElasticsearchRecorder recorder, List<HibernateSearchIntegrationStaticConfiguredBuildItem> integrationStaticConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> staticConfigured) {
        recorderContext.registerSubstitution(ElasticsearchVersion.class, String.class, ElasticsearchVersionSubstitution.class);
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners = new ArrayList<HibernateOrmIntegrationStaticInitListener>();
            boolean xmlMappingRequired = false;
            for (HibernateSearchIntegrationStaticConfiguredBuildItem item : integrationStaticConfigBuildItems) {
                HibernateOrmIntegrationStaticInitListener listener;
                if (item.getPersistenceUnitName().equals(puName) && (listener = item.getInitListener()) != null) {
                    integrationStaticInitListeners.add(listener);
                }
                if (!item.isXmlMappingRequired()) continue;
                xmlMappingRequired = true;
            }
            staticConfigured.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createStaticInitListener(puName, configuredPersistenceUnit.getBuildTimeConfig(), configuredPersistenceUnit.getBackendAndIndexNamesForSearchExtensions(), integrationStaticInitListeners)).setXmlMappingRequired(xmlMappingRequired));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setRuntimeConfig(HibernateSearchElasticsearchRecorder recorder, HibernateSearchElasticsearchRuntimeConfig runtimeConfig, List<HibernateSearchIntegrationRuntimeConfiguredBuildItem> integrationRuntimeConfigBuildItems, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            ArrayList<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners = new ArrayList<HibernateOrmIntegrationRuntimeInitListener>();
            for (HibernateSearchIntegrationRuntimeConfiguredBuildItem item : integrationRuntimeConfigBuildItems) {
                HibernateOrmIntegrationRuntimeInitListener listener;
                if (!item.getPersistenceUnitName().equals(puName) || (listener = item.getInitListener()) == null) continue;
                integrationRuntimeInitListeners.add(listener);
            }
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem(HIBERNATE_SEARCH_ELASTICSEARCH, puName).setInitListener(recorder.createRuntimeInitListener(runtimeConfig, puName, configuredPersistenceUnit.getBackendAndIndexNamesForSearchExtensions(), integrationRuntimeInitListeners)));
        }
    }

    @BuildStep
    public void processPersistenceUnitBuildTimeConfig(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            this.processPersistenceUnitBuildTimeConfig(configuredPersistenceUnit, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private void processPersistenceUnitBuildTimeConfig(HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        String persistenceUnitName = configuredPersistenceUnit.getPersistenceUnitName();
        HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig = configuredPersistenceUnit.getBuildTimeConfig();
        LinkedHashSet<String> propertyKeysWithNoVersion = new LinkedHashSet<String>();
        Map backends = buildTimeConfig != null ? buildTimeConfig.getAllBackendConfigsAsMap() : Collections.emptyMap();
        LinkedHashSet<String> allBackendNames = new LinkedHashSet<String>(configuredPersistenceUnit.getBackendNamesForIndexedEntities());
        allBackendNames.addAll(backends.keySet());
        for (String backendName : allBackendNames) {
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig backendConfig = (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig)backends.get(backendName);
            if (backendConfig == null || backendConfig.version.isEmpty()) {
                propertyKeysWithNoVersion.add(HibernateSearchElasticsearchRuntimeConfig.elasticsearchVersionPropertyKey((String)persistenceUnitName, (String)backendName));
            }
            if (backendConfig == null) continue;
            HibernateSearchElasticsearchProcessor.registerClasspathFileFromBackendConfig(persistenceUnitName, backendName, backendConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
        if (!propertyKeysWithNoVersion.isEmpty()) {
            throw new ConfigurationException("The Elasticsearch version needs to be defined via properties: " + String.join((CharSequence)", ", propertyKeysWithNoVersion) + ".", propertyKeysWithNoVersion);
        }
    }

    private static void registerClasspathFileFromBackendConfig(String persistenceUnitName, String backendName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig backendConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromIndexConfig(persistenceUnitName, backendName, null, backendConfig.indexDefaults, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        for (Map.Entry entry : backendConfig.indexes.entrySet()) {
            String indexName = (String)entry.getKey();
            HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig = (HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig)entry.getValue();
            HibernateSearchElasticsearchProcessor.registerClasspathFileFromIndexConfig(persistenceUnitName, backendName, indexName, indexConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private static void registerClasspathFileFromIndexConfig(String persistenceUnitName, String backendName, String indexName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromConfig(persistenceUnitName, backendName, indexName, "schema-management.settings-file", indexConfig.schemaManagement.settingsFile, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        HibernateSearchElasticsearchProcessor.registerClasspathFileFromConfig(persistenceUnitName, backendName, indexName, "schema-management.mapping-file", indexConfig.schemaManagement.mappingFile, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
    }

    private static void registerClasspathFileFromConfig(String persistenceUnitName, String backendName, String indexName, String propertyKeyRadical, Optional<String> classpathFileOptional, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (!classpathFileOptional.isPresent()) {
            return;
        }
        String classpathFile = classpathFileOptional.get();
        Path existingPath = applicationArchivesBuildItem.getRootArchive().getChildPath(classpathFile);
        if (existingPath == null || Files.isDirectory(existingPath, new LinkOption[0])) {
            throw new ConfigurationException("Unable to find file referenced in '" + HibernateSearchElasticsearchRuntimeConfig.backendPropertyKey((String)persistenceUnitName, (String)backendName, (String)indexName, (String)propertyKeyRadical) + "=" + classpathFile + "'. Remove property or add file to your path.");
        }
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{classpathFile}));
        hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(classpathFile));
    }

    private void registerReflectionForGson(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] reflectiveClasses = (String[])GsonClasses.typesRequiringReflection().toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])reflectiveClasses).methods().fields().build());
    }

    @BuildStep
    DevservicesElasticsearchBuildItem devServices(HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig) {
        if (buildTimeConfig.defaultPersistenceUnit != null && buildTimeConfig.defaultPersistenceUnit.defaultBackend != null && buildTimeConfig.defaultPersistenceUnit.defaultBackend.version.isPresent()) {
            ElasticsearchVersion version = (ElasticsearchVersion)buildTimeConfig.defaultPersistenceUnit.defaultBackend.version.get();
            String hostsPropertyKey = HibernateSearchElasticsearchRuntimeConfig.backendPropertyKey((String)"<default>", null, null, (String)"hosts");
            return new DevservicesElasticsearchBuildItem(hostsPropertyKey, version.versionString(), DevservicesElasticsearchBuildItem.Distribution.valueOf((String)version.distribution().toString().toUpperCase()));
        }
        return null;
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    void devServicesDropAndCreateAndDropByDefault(List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> configuredPersistenceUnits, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfigProducer) {
        for (HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem configuredPersistenceUnit : configuredPersistenceUnits) {
            String schemaManagementStrategyPropertyKey;
            String puName = configuredPersistenceUnit.getPersistenceUnitName();
            List propertyKeysIndicatingHostsConfigured = HibernateSearchElasticsearchRuntimeConfig.defaultBackendPropertyKeys((String)puName, (String)"hosts");
            if (ConfigUtils.isAnyPropertyPresent((Collection)propertyKeysIndicatingHostsConfigured) || ConfigUtils.isPropertyPresent((String)(schemaManagementStrategyPropertyKey = HibernateSearchElasticsearchRuntimeConfig.mapperPropertyKey((String)puName, (String)"schema-management.strategy")))) continue;
            devServicesAdditionalConfigProducer.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(devServicesConfig -> {
                if (propertyKeysIndicatingHostsConfigured.stream().anyMatch(devServicesConfig::containsKey)) {
                    String forcedValue = "drop-and-create-and-drop";
                    LOG.infof("Setting %s=%s to initialize Dev Services managed Elasticsearch server", (Object)schemaManagementStrategyPropertyKey, (Object)forcedValue);
                    return Map.of(schemaManagementStrategyPropertyKey, forcedValue);
                }
                return Map.of();
            }));
        }
    }
}

