/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.deployment.dev;

import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem;
import io.quarkus.hibernate.search.orm.elasticsearch.deployment.HibernateSearchEnabled;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.dev.HibernateSearchElasticsearchDevJsonRpcService;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.dev.HibernateSearchElasticsearchDevRecorder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@BuildSteps(onlyIf={HibernateSearchEnabled.class, IsLocalDevelopment.class})
public class HibernateSearchElasticsearchDevUIProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public CardPageBuildItem create(HibernateSearchElasticsearchDevRecorder recorder, List<HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem> persistenceUnitBuildItems) {
        Set persistenceUnitNames = persistenceUnitBuildItems.stream().map(HibernateSearchElasticsearchPersistenceUnitConfiguredBuildItem::getPersistenceUnitName).collect(Collectors.toSet());
        recorder.initController(persistenceUnitNames);
        CardPageBuildItem card = new CardPageBuildItem();
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Indexed Entity Types")).componentLink("hibernate-search-orm-elasticsearch-indexed-entity-types.js").icon("font-awesome-solid:magnifying-glass")).dynamicLabelJsonRPCMethodName("getNumberOfIndexedEntityTypes"));
        return card;
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(HibernateSearchElasticsearchDevJsonRpcService.class);
    }
}

