/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.util.common.SearchException;

@ConfigGroup
public class HibernateSearchElasticsearchRuntimeConfigPersistenceUnit {
    @ConfigItem(name="elasticsearch")
    ElasticsearchBackendRuntimeConfig defaultBackend;
    @ConfigItem(name="elasticsearch")
    public ElasticsearchNamedBackendsRuntimeConfig namedBackends;
    @ConfigItem
    SchemaManagementConfig schemaManagement;
    @ConfigItem(name="query.loading")
    SearchQueryLoadingConfig queryLoading;
    @ConfigItem
    AutomaticIndexingConfig automaticIndexing;

    @ConfigGroup
    public static class ElasticsearchIndexIndexingConfig {
        @ConfigItem(defaultValueDocumentation="10")
        OptionalInt queueCount;
        @ConfigItem(defaultValueDocumentation="1000")
        OptionalInt queueSize;
        @ConfigItem(defaultValueDocumentation="100")
        OptionalInt maxBulkSize;
    }

    @ConfigGroup
    public static class ElasticsearchIndexSchemaManagementConfig {
        @ConfigItem(defaultValueDocumentation="yellow")
        Optional<IndexStatus> requiredStatus;
        @ConfigItem(defaultValueDocumentation="10S")
        Optional<Duration> requiredStatusWaitTimeout;
    }

    @ConfigGroup
    public static class ThreadPoolConfig {
        @ConfigItem
        OptionalInt size;
    }

    @ConfigGroup
    public static class SchemaManagementConfig {
        @ConfigItem(defaultValue="create-or-validate")
        SchemaManagementStrategyName strategy;
    }

    @ConfigGroup
    public static class SearchQueryLoadingCacheLookupConfig {
        @ConfigItem(defaultValue="skip")
        EntityLoadingCacheLookupStrategy strategy;
    }

    @ConfigGroup
    public static class SearchQueryLoadingConfig {
        @ConfigItem
        SearchQueryLoadingCacheLookupConfig cacheLookup;
        @ConfigItem(defaultValue="100")
        int fetchSize;
    }

    @ConfigGroup
    public static class AutomaticIndexingSynchronizationConfig {
        @ConfigItem(defaultValue="write-sync")
        String strategy;
    }

    @ConfigGroup
    public static class AutomaticIndexingConfig {
        @ConfigItem
        AutomaticIndexingSynchronizationConfig synchronization;
        @ConfigItem(defaultValue="true")
        boolean enableDirtyCheck;
    }

    @ConfigGroup
    public static class DiscoveryConfig {
        @ConfigItem
        boolean enabled;
        @ConfigItem(defaultValue="10S")
        Duration refreshInterval;
    }

    @ConfigGroup
    public static class ElasticsearchIndexRuntimeConfig {
        @ConfigItem
        ElasticsearchIndexSchemaManagementConfig schemaManagement;
        @ConfigItem
        ElasticsearchIndexIndexingConfig indexing;
    }

    public static enum ElasticsearchClientProtocol {
        HTTP("http"),
        HTTPS("https");

        private final String hibernateSearchString;

        public static ElasticsearchClientProtocol of(String value) {
            return (ElasticsearchClientProtocol)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchClientProtocol.values(), ElasticsearchClientProtocol::getHibernateSearchString, (invalidValue, validValues) -> new SearchException(String.format(Locale.ROOT, "Invalid protocol: '%1$s'. Valid protocols are: %2$s.", invalidValue, validValues)), (String)value));
        }

        private ElasticsearchClientProtocol(String hibernateSearchString) {
            this.hibernateSearchString = hibernateSearchString;
        }

        public String getHibernateSearchString() {
            return this.hibernateSearchString;
        }
    }

    @ConfigGroup
    public static class ElasticsearchBackendRuntimeConfig {
        @ConfigItem(defaultValue="localhost:9200")
        List<String> hosts;
        @ConfigItem(defaultValue="http")
        ElasticsearchClientProtocol protocol;
        @ConfigItem
        Optional<String> username;
        @ConfigItem
        Optional<String> password;
        @ConfigItem(defaultValue="1S")
        Duration connectionTimeout;
        @ConfigItem(defaultValue="30S")
        Duration readTimeout;
        @ConfigItem
        Optional<Duration> requestTimeout;
        @ConfigItem(defaultValue="20")
        int maxConnections;
        @ConfigItem(defaultValue="10")
        int maxConnectionsPerRoute;
        @ConfigItem
        DiscoveryConfig discovery;
        @ConfigItem
        ThreadPoolConfig threadPool;
        @ConfigItem(name="<<parent>>")
        ElasticsearchIndexRuntimeConfig indexDefaults;
        @ConfigItem
        Map<String, ElasticsearchIndexRuntimeConfig> indexes;
    }

    @ConfigGroup
    public static class ElasticsearchNamedBackendsRuntimeConfig {
        public Map<String, ElasticsearchBackendRuntimeConfig> backends;
    }
}

