/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfigPersistenceUnit;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.enterprise.inject.literal.NamedLiteral;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

@Recorder
public class HibernateSearchElasticsearchRecorder {
    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
        return new HibernateSearchIntegrationStaticInitListener(buildTimeConfig, integrationStaticInitListeners);
    }

    public HibernateOrmIntegrationStaticInitListener createDisabledStaticInitListener() {
        return new HibernateSearchIntegrationDisabledListener();
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitListener(HibernateSearchElasticsearchRuntimeConfig runtimeConfig, String persistenceUnitName, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
        HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puConfig = this.runtimePuConfig(runtimeConfig, persistenceUnitName);
        return new HibernateSearchIntegrationRuntimeInitListener(puConfig, integrationRuntimeInitListeners);
    }

    public HibernateOrmIntegrationRuntimeInitListener createDisabledRuntimeInitListener() {
        return new HibernateSearchIntegrationRuntimeInitListener(null, Collections.emptyList());
    }

    public Supplier<SearchMapping> searchMappingSupplier(final HibernateSearchElasticsearchRuntimeConfig runtimeConfig, final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchMapping>(){

            @Override
            public SearchMapping get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit config = HibernateSearchElasticsearchRecorder.this.runtimePuConfig(runtimeConfig, persistenceUnitName);
                if (config != null && !config.enabled) {
                    throw new IllegalStateException("Cannot retrieve the SearchMapping: Hibernate Search was disabled through configuration properties");
                }
                SessionFactory sessionFactory = isDefaultPersistenceUnit ? (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[0]).get() : (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.mapping((SessionFactory)sessionFactory);
            }
        };
    }

    public Supplier<SearchSession> searchSessionSupplier(final HibernateSearchElasticsearchRuntimeConfig runtimeConfig, final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchSession>(){

            @Override
            public SearchSession get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit config = HibernateSearchElasticsearchRecorder.this.runtimePuConfig(runtimeConfig, persistenceUnitName);
                if (config != null && !config.enabled) {
                    throw new IllegalStateException("Cannot retrieve the SearchSession: Hibernate Search was disabled through configuration properties");
                }
                Session session = isDefaultPersistenceUnit ? (Session)Arc.container().instance(Session.class, new Annotation[0]).get() : (Session)Arc.container().instance(Session.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.session((Session)session);
            }
        };
    }

    private HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimePuConfig(HibernateSearchElasticsearchRuntimeConfig runtimeConfig, String persistenceUnitName) {
        return PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName) ? runtimeConfig.defaultPersistenceUnit : runtimeConfig.persistenceUnits.get(persistenceUnitName);
    }

    private static final class HibernateSearchIntegrationRuntimeInitListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private final HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig;
        private final List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners;

        private HibernateSearchIntegrationRuntimeInitListener(HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
            this.runtimeConfig = runtimeConfig;
            this.integrationRuntimeInitListeners = integrationRuntimeInitListeners;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig == null) {
                return;
            }
            if (!this.runtimeConfig.enabled) {
                HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.enabled", false);
                return;
            }
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.schema_management.strategy", this.runtimeConfig.schemaManagement.strategy);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.automatic_indexing.synchronization.strategy", this.runtimeConfig.automaticIndexing.synchronization.strategy);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.automatic_indexing.enable_dirty_check", this.runtimeConfig.automaticIndexing.enableDirtyCheck);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.query.loading.cache_lookup.strategy", this.runtimeConfig.queryLoading.cacheLookup.strategy);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.query.loading.fetch_size", this.runtimeConfig.queryLoading.fetchSize);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.multi_tenancy.tenant_ids", this.runtimeConfig.multiTenancy.tenantIds);
            this.contributeBackendRuntimeProperties(propertyCollector, null, this.runtimeConfig.defaultBackend);
            for (Map.Entry<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig> backendEntry : this.runtimeConfig.namedBackends.backends.entrySet()) {
                this.contributeBackendRuntimeProperties(propertyCollector, backendEntry.getKey(), backendEntry.getValue());
            }
            for (HibernateOrmIntegrationRuntimeInitListener integrationRuntimeInitListener : this.integrationRuntimeInitListeners) {
                integrationRuntimeInitListener.contributeRuntimeProperties(propertyCollector);
            }
        }

        private void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig elasticsearchBackendConfig) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "hosts", elasticsearchBackendConfig.hosts);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "protocol", elasticsearchBackendConfig.protocol.getHibernateSearchString());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "username", elasticsearchBackendConfig.username);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "password", elasticsearchBackendConfig.password);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "connection_timeout", elasticsearchBackendConfig.connectionTimeout.toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "read_timeout", elasticsearchBackendConfig.readTimeout.toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "request_timeout", elasticsearchBackendConfig.requestTimeout, Optional::isPresent, d -> ((Duration)d.get()).toMillis());
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections", elasticsearchBackendConfig.maxConnections);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "max_connections_per_route", elasticsearchBackendConfig.maxConnectionsPerRoute);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "thread_pool.size", elasticsearchBackendConfig.threadPool.size);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version_check.enabled", elasticsearchBackendConfig.versionCheck);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.enabled", elasticsearchBackendConfig.discovery.enabled);
            if (elasticsearchBackendConfig.discovery.enabled) {
                HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "discovery.refresh_interval", elasticsearchBackendConfig.discovery.refreshInterval.getSeconds());
            }
            this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig.indexDefaults);
            for (Map.Entry<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchIndexRuntimeConfig> indexConfigEntry : this.runtimeConfig.defaultBackend.indexes.entrySet()) {
                String indexName = indexConfigEntry.getKey();
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchIndexRuntimeConfig indexConfig = indexConfigEntry.getValue();
                this.contributeBackendIndexRuntimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit.ElasticsearchIndexRuntimeConfig indexConfig) {
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status", indexConfig.schemaManagement.requiredStatus);
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.minimal_required_status_wait_timeout", indexConfig.schemaManagement.requiredStatusWaitTimeout, Optional::isPresent, d -> ((Duration)d.get()).toMillis());
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_count", indexConfig.indexing.queueCount);
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.queue_size", indexConfig.indexing.queueSize);
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "indexing.max_bulk_size", indexConfig.indexing.maxBulkSize);
        }

        public List<StandardServiceInitiator<?>> contributeServiceInitiators() {
            return List.of(new HibernateSearchPreIntegrationService.Initiator());
        }
    }

    private static final class HibernateSearchIntegrationStaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig;
        private final List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners;

        private HibernateSearchIntegrationStaticInitListener(HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
            this.buildTimeConfig = buildTimeConfig;
            this.integrationStaticInitListeners = integrationStaticInitListeners;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.background_failure_handler", this.buildTimeConfig.backgroundFailureHandler);
            HibernateSearchConfigUtil.addConfig(propertyCollector, "hibernate.search.coordination.strategy", this.buildTimeConfig.coordination.strategy);
            this.contributeBackendBuildTimeProperties(propertyCollector, null, this.buildTimeConfig.defaultBackend);
            for (Map.Entry<String, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig> backendEntry : this.buildTimeConfig.namedBackends.backends.entrySet()) {
                this.contributeBackendBuildTimeProperties(propertyCollector, backendEntry.getKey(), backendEntry.getValue());
            }
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.contributeBootProperties(propertyCollector);
            }
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
            HibernateOrmIntegrationBooter booter = HibernateOrmIntegrationBooter.builder((Metadata)metadata, (BootstrapContext)bootstrapContext).valueReadHandleFactory(ValueReadHandleFactory.usingJavaLangReflect()).build();
            booter.preBoot(propertyCollector);
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.onMetadataInitialized(metadata, bootstrapContext, propertyCollector);
            }
        }

        private void contributeBackendBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchBackendBuildTimeConfig elasticsearchBackendConfig) {
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "type", "elasticsearch");
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "version", elasticsearchBackendConfig.version);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, backendName, "layout.strategy", elasticsearchBackendConfig.layout.strategy);
            this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, null, elasticsearchBackendConfig.indexDefaults);
            for (Map.Entry<String, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig> indexConfigEntry : elasticsearchBackendConfig.indexes.entrySet()) {
                String indexName = indexConfigEntry.getKey();
                HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig = indexConfigEntry.getValue();
                this.contributeBackendIndexBuildTimeProperties(propertyCollector, backendName, indexName, indexConfig);
            }
        }

        private void contributeBackendIndexBuildTimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, String indexName, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit.ElasticsearchIndexBuildTimeConfig indexConfig) {
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.settings_file", indexConfig.schemaManagement.settingsFile);
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "schema_management.mapping_file", indexConfig.schemaManagement.mappingFile);
            HibernateSearchConfigUtil.addBackendIndexConfig(propertyCollector, backendName, indexName, "analysis.configurer", indexConfig.analysis.configurer);
        }
    }

    private static final class HibernateSearchIntegrationDisabledListener
    implements HibernateOrmIntegrationStaticInitListener {
        private HibernateSearchIntegrationDisabledListener() {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.search.enabled", false);
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }
}

