/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;

public class HibernateSearchSupplier
implements Supplier<List<DevUiIndexedEntity>> {
    private final HibernateSearchElasticsearchRuntimeConfig runtimeConfig;

    HibernateSearchSupplier(HibernateSearchElasticsearchRuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    @Override
    public List<DevUiIndexedEntity> get() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        SearchMapping mapping = HibernateSearchSupplier.searchMapping();
        if (mapping == null) {
            return Collections.emptyList();
        }
        return mapping.allIndexedEntities().stream().map(DevUiIndexedEntity::new).sorted().collect(Collectors.toList());
    }

    private boolean isEnabled() {
        return this.runtimeConfig.defaultPersistenceUnit.enabled;
    }

    public static SearchMapping searchMapping() {
        return (SearchMapping)Arc.container().instance(SearchMapping.class, new Annotation[0]).get();
    }

    public static class DevUiIndexedEntity
    implements Comparable<DevUiIndexedEntity> {
        public final String jpaName;
        public final String javaClass;

        DevUiIndexedEntity(SearchIndexedEntity<?> searchIndexedEntity) {
            this.jpaName = searchIndexedEntity.jpaName();
            this.javaClass = searchIndexedEntity.javaClass().getName();
        }

        @Override
        public int compareTo(DevUiIndexedEntity o) {
            return this.jpaName.compareTo(o.jpaName);
        }
    }
}

