/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime.devconsole;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.devconsole.HibernateSearchSupplier;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;

@Recorder
public class HibernateSearchDevConsoleRecorder {
    public Supplier<List<HibernateSearchSupplier.DevUiIndexedEntity>> infoSupplier(HibernateSearchElasticsearchRuntimeConfig runtimeConfig) {
        return new HibernateSearchSupplier(runtimeConfig);
    }

    public Handler<RoutingContext> indexEntity() {
        return new DevConsolePostHandler(){

            protected void handlePostAsync(RoutingContext event, MultiMap form) throws Exception {
                if (form.isEmpty()) {
                    return;
                }
                SearchMapping mapping = HibernateSearchSupplier.searchMapping();
                if (mapping == null) {
                    this.flashMessage(event, "There are no indexed entity types.", FlashScopeUtil.FlashMessageStatus.ERROR);
                    return;
                }
                mapping.scope(Object.class, (Collection)mapping.allIndexedEntities().stream().map(SearchIndexedEntity::jpaName).filter(arg_0 -> ((MultiMap)form).contains(arg_0)).collect(Collectors.toList())).massIndexer().startAndWait();
                this.flashMessage(event, "Entities successfully reindexed", Duration.ofSeconds(10L));
            }
        };
    }
}

