/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;

@ConfigGroup
public class HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit {
    @ConfigItem(name="elasticsearch")
    public ElasticsearchBackendBuildTimeConfig defaultBackend;
    @ConfigItem(name="elasticsearch")
    ElasticsearchNamedBackendsBuildTimeConfig namedBackends;
    @ConfigItem
    public Optional<String> backgroundFailureHandler;
    @ConfigItem
    public CoordinationConfig coordination;

    public Map<String, ElasticsearchBackendBuildTimeConfig> getAllBackendConfigsAsMap() {
        LinkedHashMap<String, ElasticsearchBackendBuildTimeConfig> map = new LinkedHashMap<String, ElasticsearchBackendBuildTimeConfig>();
        if (this.defaultBackend != null) {
            map.put(null, this.defaultBackend);
        }
        if (this.namedBackends != null) {
            map.putAll(this.namedBackends.backends);
        }
        return map;
    }

    @ConfigGroup
    public static class CoordinationConfig {
        @ConfigItem(defaultValue="none")
        public Optional<String> strategy;
    }

    @ConfigGroup
    public static class LayoutConfig {
        @ConfigItem
        public Optional<String> strategy;
    }

    @ConfigGroup
    public static class AnalysisConfig {
        @ConfigItem
        public Optional<String> configurer;
    }

    @ConfigGroup
    public static class SchemaManagementConfig {
        @ConfigItem
        public Optional<String> settingsFile;
        @ConfigItem
        public Optional<String> mappingFile;
    }

    @ConfigGroup
    public static class ElasticsearchIndexBuildTimeConfig {
        @ConfigItem
        public SchemaManagementConfig schemaManagement;
        @ConfigItem
        public AnalysisConfig analysis;
    }

    @ConfigGroup
    public static class ElasticsearchBackendBuildTimeConfig {
        @ConfigItem
        public Optional<ElasticsearchVersion> version;
        @ConfigItem
        public LayoutConfig layout;
        @ConfigItem(name="<<parent>>")
        public ElasticsearchIndexBuildTimeConfig indexDefaults;
        @ConfigItem
        public Map<String, ElasticsearchIndexBuildTimeConfig> indexes;
    }

    @ConfigGroup
    public static class ElasticsearchNamedBackendsBuildTimeConfig {
        public Map<String, ElasticsearchBackendBuildTimeConfig> backends;
    }
}

