/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfigPersistenceUnit;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ConfigRoot(name="hibernate-search-orm", phase=ConfigPhase.RUN_TIME)
public class HibernateSearchElasticsearchRuntimeConfig {
    @ConfigItem(name="<<parent>>")
    public HibernateSearchElasticsearchRuntimeConfigPersistenceUnit defaultPersistenceUnit;
    @ConfigItem(name="<<parent>>")
    public Map<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit> persistenceUnits;

    public Map<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit> getAllPersistenceUnitConfigsAsMap() {
        TreeMap<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit> map = new TreeMap<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit>();
        if (this.defaultPersistenceUnit != null) {
            map.put("<default>", this.defaultPersistenceUnit);
        }
        map.putAll(this.persistenceUnits);
        return map;
    }

    public static String elasticsearchVersionPropertyKey(String persistenceUnitName, String backendName) {
        return HibernateSearchElasticsearchRuntimeConfig.backendPropertyKey(persistenceUnitName, backendName, null, "version");
    }

    public static String extensionPropertyKey(String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-orm.");
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static String mapperPropertyKey(String persistenceUnitName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-orm.");
        if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            keyBuilder.append("\"").append(persistenceUnitName).append("\".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static String backendPropertyKey(String persistenceUnitName, String backendName, String indexName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-orm.");
        if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            keyBuilder.append("\"").append(persistenceUnitName).append("\".");
        }
        keyBuilder.append("elasticsearch.");
        if (backendName != null) {
            keyBuilder.append("\"").append(backendName).append("\".");
        }
        if (indexName != null) {
            keyBuilder.append("indexes.\"").append(indexName).append("\".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static List<String> defaultBackendPropertyKeys(String persistenceUnitName, String radical) {
        if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            return List.of("quarkus.hibernate-search-orm.elasticsearch." + radical);
        }
        return List.of("quarkus.hibernate-search-orm.\"" + persistenceUnitName + "\".elasticsearch." + radical, "quarkus.hibernate-search-orm." + persistenceUnitName + ".elasticsearch." + radical);
    }
}

