/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime.dev;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;

class HibernateSearchElasticsearchDevInfo {
    private final Set<PersistenceUnit> persistenceUnits = new TreeSet<PersistenceUnit>(new PersistenceUnitComparator());

    HibernateSearchElasticsearchDevInfo() {
    }

    public Set<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    public void add(PersistenceUnit indexedPersistenceUnit) {
        this.persistenceUnits.add(indexedPersistenceUnit);
    }

    public void addAll(HibernateSearchElasticsearchDevInfo right) {
        this.persistenceUnits.addAll(right.persistenceUnits);
    }

    public int getNumberOfIndexedEntities() {
        return this.persistenceUnits.stream().mapToInt(pu -> pu.indexedEntities.size()).sum();
    }

    public static class IndexedEntity
    implements Comparable<IndexedEntity> {
        public final String jpaName;
        public final String javaClass;
        public final Set<String> indexNames = new HashSet<String>();

        IndexedEntity(SearchIndexedEntity<?> searchIndexedEntity) {
            this.jpaName = searchIndexedEntity.jpaName();
            this.javaClass = searchIndexedEntity.javaClass().getName();
            ElasticsearchIndexManager indexManager = (ElasticsearchIndexManager)searchIndexedEntity.indexManager().unwrap(ElasticsearchIndexManager.class);
            this.indexNames.add(indexManager.descriptor().readName());
            this.indexNames.add(indexManager.descriptor().writeName());
        }

        @Override
        public int compareTo(IndexedEntity o) {
            return this.jpaName.compareTo(o.jpaName);
        }
    }

    static class PersistenceUnit
    implements Comparable<PersistenceUnit> {
        public final String name;
        public final List<IndexedEntity> indexedEntities;

        public PersistenceUnit(String name, List<IndexedEntity> indexedEntities) {
            this.name = name;
            this.indexedEntities = indexedEntities;
        }

        @Deprecated
        public String getPersistenceUnitName() {
            return this.name;
        }

        @Override
        public int compareTo(PersistenceUnit o) {
            return this.name.compareTo(o.name);
        }
    }

    static class PersistenceUnitComparator
    implements Comparator<PersistenceUnit> {
        Comparator<String> persistenceUnitNameComparator = new PersistenceUnitUtil.PersistenceUnitNameComparator();

        PersistenceUnitComparator() {
        }

        @Override
        public int compare(PersistenceUnit o1, PersistenceUnit o2) {
            return this.persistenceUnitNameComparator.compare(o1.name, o2.name);
        }
    }
}

