/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.util.common.SearchException;

@ConfigGroup
public interface HibernateSearchElasticsearchRuntimeConfigPersistenceUnit {
    @ConfigDocDefault(value="'true' if Hibernate Search is enabled; 'false' otherwise")
    public Optional<Boolean> active();

    @ConfigDocSection
    @WithName(value="elasticsearch")
    @WithUnnamedKey
    @ConfigDocMapKey(value="backend-name")
    public Map<String, ElasticsearchBackendRuntimeConfig> backends();

    public SchemaManagementConfig schemaManagement();

    @WithName(value="query.loading")
    public SearchQueryLoadingConfig queryLoading();

    public IndexingConfig indexing();

    @Deprecated
    public AutomaticIndexingConfig automaticIndexing();

    public MultiTenancyConfig multiTenancy();

    @ConfigGroup
    public static interface MultiTenancyConfig {
        public Optional<List<String>> tenantIds();
    }

    @ConfigGroup
    public static interface ElasticsearchIndexIndexingConfig {
        @ConfigDocDefault(value="10")
        public OptionalInt queueCount();

        @ConfigDocDefault(value="1000")
        public OptionalInt queueSize();

        @ConfigDocDefault(value="100")
        public OptionalInt maxBulkSize();
    }

    @ConfigGroup
    public static interface ElasticsearchIndexSchemaManagementConfig {
        @ConfigDocDefault(value="yellow")
        public Optional<IndexStatus> requiredStatus();

        @ConfigDocDefault(value="10S")
        public Optional<Duration> requiredStatusWaitTimeout();
    }

    @ConfigGroup
    public static interface ElasticsearchQueryShardFailureConfig {
        @WithDefault(value="false")
        public boolean ignore();
    }

    @ConfigGroup
    public static interface ElasticsearchQueryConfig {
        public ElasticsearchQueryShardFailureConfig shardFailure();
    }

    @ConfigGroup
    public static interface ThreadPoolConfig {
        public OptionalInt size();
    }

    @ConfigGroup
    public static interface SchemaManagementConfig {
        @WithDefault(value="create-or-validate")
        @ConfigDocDefault(value="drop-and-create-and-drop when using Dev Services; create-or-validate otherwise")
        public SchemaManagementStrategyName strategy();
    }

    @ConfigGroup
    public static interface SearchQueryLoadingCacheLookupConfig {
        @WithDefault(value="skip")
        public EntityLoadingCacheLookupStrategy strategy();
    }

    @ConfigGroup
    public static interface SearchQueryLoadingConfig {
        public SearchQueryLoadingCacheLookupConfig cacheLookup();

        @WithDefault(value="100")
        public int fetchSize();
    }

    @ConfigGroup
    @Deprecated
    public static interface AutomaticIndexingSynchronizationConfig {
        @ConfigDocDefault(value="write-sync")
        public Optional<String> strategy();
    }

    @ConfigGroup
    @Deprecated
    public static interface AutomaticIndexingConfig {
        public AutomaticIndexingSynchronizationConfig synchronization();

        @WithDefault(value="true")
        @Deprecated
        public boolean enableDirtyCheck();
    }

    @ConfigGroup
    public static interface IndexingPlanSynchronizationConfig {
        @ConfigDocDefault(value="write-sync")
        public Optional<String> strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanConfig {
        public IndexingPlanSynchronizationConfig synchronization();
    }

    @ConfigGroup
    public static interface IndexingConfig {
        public IndexingPlanConfig plan();
    }

    @ConfigGroup
    public static interface DiscoveryConfig {
        @WithDefault(value="false")
        public Boolean enabled();

        @WithDefault(value="10S")
        public Duration refreshInterval();
    }

    @ConfigGroup
    public static interface ElasticsearchIndexRuntimeConfig {
        public ElasticsearchIndexSchemaManagementConfig schemaManagement();

        public ElasticsearchIndexIndexingConfig indexing();
    }

    @ConfigGroup
    public static interface ElasticsearchVersionCheckConfig {
        @WithDefault(value="true")
        public boolean enabled();
    }

    public static enum ElasticsearchClientProtocol {
        HTTP("http"),
        HTTPS("https");

        private final String hibernateSearchString;

        public static ElasticsearchClientProtocol of(String value) {
            return (ElasticsearchClientProtocol)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchClientProtocol.values(), ElasticsearchClientProtocol::getHibernateSearchString, (invalidValue, validValues) -> new SearchException(String.format(Locale.ROOT, "Invalid protocol: '%1$s'. Valid protocols are: %2$s.", invalidValue, validValues)), (String)value));
        }

        private ElasticsearchClientProtocol(String hibernateSearchString) {
            this.hibernateSearchString = hibernateSearchString;
        }

        public String getHibernateSearchString() {
            return this.hibernateSearchString;
        }
    }

    @ConfigGroup
    public static interface ElasticsearchBackendRuntimeConfig {
        @WithDefault(value="localhost:9200")
        public List<String> hosts();

        @WithDefault(value="http")
        public ElasticsearchClientProtocol protocol();

        public Optional<String> username();

        public Optional<String> password();

        @WithDefault(value="1S")
        public Duration connectionTimeout();

        @WithDefault(value="30S")
        public Duration readTimeout();

        public Optional<Duration> requestTimeout();

        @WithDefault(value="20")
        public int maxConnections();

        @WithDefault(value="10")
        public int maxConnectionsPerRoute();

        public DiscoveryConfig discovery();

        public ThreadPoolConfig threadPool();

        public ElasticsearchQueryConfig query();

        public ElasticsearchVersionCheckConfig versionCheck();

        @WithParentName
        public ElasticsearchIndexRuntimeConfig indexDefaults();

        @ConfigDocSection
        @ConfigDocMapKey(value="index-name")
        public Map<String, ElasticsearchIndexRuntimeConfig> indexes();
    }
}

