/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchConfigHandler;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchConfigUtil;
import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.MapperContext;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchElasticsearchRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchOrmElasticsearchMapperContext;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.bean.HibernateSearchBeanUtil;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.management.HibernateSearchManagementHandler;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.mapping.QuarkusHibernateOrmSearchMappingConfigurer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;

@Recorder
public class HibernateSearchElasticsearchRecorder {
    private final HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig;
    private final RuntimeValue<HibernateSearchElasticsearchRuntimeConfig> runtimeConfig;

    public HibernateSearchElasticsearchRecorder(HibernateSearchElasticsearchBuildTimeConfig buildTimeConfig, RuntimeValue<HibernateSearchElasticsearchRuntimeConfig> runtimeConfig) {
        this.buildTimeConfig = buildTimeConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(HibernateSearchOrmElasticsearchMapperContext mapperContext, Set<String> rootAnnotationMappedClassNames, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
        LinkedHashSet rootAnnotationMappedClasses = new LinkedHashSet();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (String className : rootAnnotationMappedClassNames) {
            try {
                rootAnnotationMappedClasses.add(Class.forName(className, true, tccl));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize mapped class " + className, e);
            }
        }
        return new HibernateSearchIntegrationStaticInitListener(mapperContext, this.buildTimeConfig.persistenceUnits().get(mapperContext.persistenceUnitName), rootAnnotationMappedClasses, integrationStaticInitListeners);
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitInactiveListener() {
        return new HibernateSearchIntegrationStaticInitInactiveListener();
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitListener(HibernateSearchOrmElasticsearchMapperContext mapperContext, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
        HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puConfig = ((HibernateSearchElasticsearchRuntimeConfig)this.runtimeConfig.getValue()).persistenceUnits().get(mapperContext.persistenceUnitName);
        return new HibernateSearchIntegrationRuntimeInitListener(mapperContext, puConfig, integrationRuntimeInitListeners);
    }

    public void checkNoExplicitActiveTrue() {
        for (Map.Entry<String, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit> entry : ((HibernateSearchElasticsearchRuntimeConfig)this.runtimeConfig.getValue()).persistenceUnits().entrySet()) {
            HibernateSearchElasticsearchRuntimeConfigPersistenceUnit config = entry.getValue();
            if (!config.active().orElse(false).booleanValue()) continue;
            String puName = entry.getKey();
            String enabledPropertyKey = HibernateSearchElasticsearchRuntimeConfig.extensionPropertyKey("enabled");
            String activePropertyKey = HibernateSearchElasticsearchRuntimeConfig.mapperPropertyKey(puName, "active");
            throw new ConfigurationException("Hibernate Search activated explicitly for persistence unit '" + puName + "', but the Hibernate Search extension was disabled at build time. If you want Hibernate Search to be active for this persistence unit, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate Search to be active for this persistence unit, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }

    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitInactiveListener() {
        return new HibernateSearchIntegrationRuntimeInitInactiveListener();
    }

    public Supplier<SearchMapping> searchMappingSupplier(final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchMapping>(){

            @Override
            public SearchMapping get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puRuntimeConfig = ((HibernateSearchElasticsearchRuntimeConfig)HibernateSearchElasticsearchRecorder.this.runtimeConfig.getValue()).persistenceUnits().get(persistenceUnitName);
                if (puRuntimeConfig != null && !puRuntimeConfig.active().orElse(true).booleanValue()) {
                    throw new IllegalStateException("Cannot retrieve the SearchMapping for persistence unit " + persistenceUnitName + ": Hibernate Search was deactivated through configuration properties");
                }
                SessionFactory sessionFactory = isDefaultPersistenceUnit ? (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[0]).get() : (SessionFactory)Arc.container().instance(SessionFactory.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.mapping((SessionFactory)sessionFactory);
            }
        };
    }

    public Supplier<SearchSession> searchSessionSupplier(final String persistenceUnitName, final boolean isDefaultPersistenceUnit) {
        return new Supplier<SearchSession>(){

            @Override
            public SearchSession get() {
                HibernateSearchElasticsearchRuntimeConfigPersistenceUnit puRuntimeConfig = ((HibernateSearchElasticsearchRuntimeConfig)HibernateSearchElasticsearchRecorder.this.runtimeConfig.getValue()).persistenceUnits().get(persistenceUnitName);
                if (puRuntimeConfig != null && !puRuntimeConfig.active().orElse(true).booleanValue()) {
                    throw new IllegalStateException("Cannot retrieve the SearchSession for persistence unit " + persistenceUnitName + ": Hibernate Search was deactivated through configuration properties");
                }
                Session session = isDefaultPersistenceUnit ? (Session)Arc.container().instance(Session.class, new Annotation[0]).get() : (Session)Arc.container().instance(Session.class, new Annotation[]{NamedLiteral.of((String)persistenceUnitName)}).get();
                return Search.session((Session)session);
            }
        };
    }

    public Handler<RoutingContext> managementHandler() {
        return new HibernateSearchManagementHandler();
    }

    private static void mergeInto(Map<String, Set<String>> target, Map<String, Set<String>> source) {
        for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
            HibernateSearchElasticsearchRecorder.mergeInto(target, entry.getKey(), entry.getValue());
        }
    }

    private static void mergeInto(Map<String, Set<String>> target, String key, Set<String> values) {
        target.computeIfAbsent(key, ignored -> new LinkedHashSet()).addAll(values);
    }

    private static final class HibernateSearchIntegrationStaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final HibernateSearchOrmElasticsearchMapperContext mapperContext;
        private final String persistenceUnitName;
        private final HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig;
        private final Set<Class<?>> rootAnnotationMappedClasses;
        private final List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners;

        private HibernateSearchIntegrationStaticInitListener(HibernateSearchOrmElasticsearchMapperContext mapperContext, HibernateSearchElasticsearchBuildTimeConfigPersistenceUnit buildTimeConfig, Set<Class<?>> rootAnnotationMappedClasses, List<HibernateOrmIntegrationStaticInitListener> integrationStaticInitListeners) {
            this.mapperContext = mapperContext;
            this.persistenceUnitName = mapperContext.persistenceUnitName;
            this.buildTimeConfig = buildTimeConfig;
            this.rootAnnotationMappedClasses = rootAnnotationMappedClasses;
            this.integrationStaticInitListeners = integrationStaticInitListeners;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.background_failure_handler", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.backgroundFailureHandler(), FailureHandler.class, this.persistenceUnitName, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.mapping.configurer", this.collectAllHibernateOrmSearchMappingConfigurers());
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.coordination.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.buildTimeConfig == null ? Optional.empty() : this.buildTimeConfig.coordination().strategy(), CoordinationStrategy.class, this.persistenceUnitName, null, null));
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendBuildTimeProperties(propertyCollector, (MapperContext)this.mapperContext, this.buildTimeConfig == null ? Collections.emptyMap() : this.buildTimeConfig.backends());
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.contributeBootProperties(propertyCollector);
            }
        }

        private List<BeanReference<HibernateOrmSearchMappingConfigurer>> collectAllHibernateOrmSearchMappingConfigurers() {
            ArrayList<BeanReference<HibernateOrmSearchMappingConfigurer>> configurers = new ArrayList<BeanReference<HibernateOrmSearchMappingConfigurer>>();
            configurers.add(BeanReference.ofInstance((Object)new QuarkusHibernateOrmSearchMappingConfigurer(this.rootAnnotationMappedClasses)));
            Optional<List<BeanReference<HibernateOrmSearchMappingConfigurer>>> beanReferences = HibernateSearchBeanUtil.multiExtensionBeanReferencesFor(this.buildTimeConfig.mapping().configurer(), HibernateOrmSearchMappingConfigurer.class, this.persistenceUnitName, null, null);
            if (beanReferences.isPresent()) {
                configurers.addAll((Collection<BeanReference<HibernateOrmSearchMappingConfigurer>>)beanReferences.get());
            }
            return configurers;
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
            HibernateOrmIntegrationBooter booter = HibernateOrmIntegrationBooter.builder((Metadata)metadata, (BootstrapContext)bootstrapContext).valueReadHandleFactory(ValueHandleFactory.usingJavaLangReflect()).build();
            booter.preBoot(propertyCollector);
            for (HibernateOrmIntegrationStaticInitListener listener : this.integrationStaticInitListeners) {
                listener.onMetadataInitialized(metadata, bootstrapContext, propertyCollector);
            }
        }
    }

    private static final class HibernateSearchIntegrationStaticInitInactiveListener
    implements HibernateOrmIntegrationStaticInitListener {
        private HibernateSearchIntegrationStaticInitInactiveListener() {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.search.enabled", false);
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }

    private static final class HibernateSearchIntegrationRuntimeInitListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private final HibernateSearchOrmElasticsearchMapperContext mapperContext;
        private final String persistenceUnitName;
        private final HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig;
        private final List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners;

        private HibernateSearchIntegrationRuntimeInitListener(HibernateSearchOrmElasticsearchMapperContext mapperContext, HibernateSearchElasticsearchRuntimeConfigPersistenceUnit runtimeConfig, List<HibernateOrmIntegrationRuntimeInitListener> integrationRuntimeInitListeners) {
            this.mapperContext = mapperContext;
            this.persistenceUnitName = mapperContext.persistenceUnitName;
            this.runtimeConfig = runtimeConfig;
            this.integrationRuntimeInitListeners = integrationRuntimeInitListeners;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            if (this.runtimeConfig != null) {
                if (!this.runtimeConfig.active().orElse(true).booleanValue()) {
                    HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.enabled", (Object)false);
                    return;
                }
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.schema_management.strategy", (Object)this.runtimeConfig.schemaManagement().strategy());
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.automatic_indexing.enable_dirty_check", (Object)this.runtimeConfig.automaticIndexing().enableDirtyCheck());
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.query.loading.cache_lookup.strategy", (Object)this.runtimeConfig.queryLoading().cacheLookup().strategy());
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.query.loading.fetch_size", (Object)this.runtimeConfig.queryLoading().fetchSize());
                HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.multi_tenancy.tenant_ids", this.runtimeConfig.multiTenancy().tenantIds());
            }
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.indexing.plan.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.indexing().plan().synchronization().strategy(), IndexingPlanSynchronizationStrategy.class, this.persistenceUnitName, null, null));
            HibernateSearchConfigUtil.addConfig(propertyCollector, (String)"hibernate.search.automatic_indexing.synchronization.strategy", HibernateSearchBeanUtil.singleExtensionBeanReferenceFor(this.runtimeConfig == null ? Optional.empty() : this.runtimeConfig.automaticIndexing().synchronization().strategy(), AutomaticIndexingSynchronizationStrategy.class, this.persistenceUnitName, null, null));
            HibernateSearchBackendElasticsearchConfigHandler.contributeBackendRuntimeProperties(propertyCollector, (MapperContext)this.mapperContext, this.runtimeConfig == null ? Collections.emptyMap() : this.runtimeConfig.backends());
            for (HibernateOrmIntegrationRuntimeInitListener integrationRuntimeInitListener : this.integrationRuntimeInitListeners) {
                integrationRuntimeInitListener.contributeRuntimeProperties(propertyCollector);
            }
        }

        public List<StandardServiceInitiator<?>> contributeServiceInitiators() {
            return List.of(new HibernateSearchPreIntegrationService.Initiator());
        }
    }

    private static final class HibernateSearchIntegrationRuntimeInitInactiveListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private HibernateSearchIntegrationRuntimeInitInactiveListener() {
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.search.enabled", false);
        }

        public List<StandardServiceInitiator<?>> contributeServiceInitiators() {
            return List.of(new HibernateSearchPreIntegrationService.Initiator());
        }
    }
}

