/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.deployment;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DevServicesAdditionalConfigBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.elasticsearch.restclient.common.deployment.ElasticsearchDevServicesBuildTimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.deployment.HibernateSearchStandaloneEnabled;
import io.quarkus.hibernate.search.standalone.elasticsearch.deployment.HibernateSearchStandaloneEnabledBuildItem;
import io.quarkus.hibernate.search.standalone.elasticsearch.deployment.HibernateSearchStandaloneManagementEnabled;
import io.quarkus.hibernate.search.standalone.elasticsearch.deployment.HibernateSearchTypes;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.ElasticsearchVersionSubstitution;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneBuildTimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneRecorder;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.HibernateSearchStandaloneRuntimeConfig;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.management.HibernateSearchStandaloneManagementConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonClasses;
import org.hibernate.search.mapper.pojo.standalone.mapping.SearchMapping;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={HibernateSearchStandaloneEnabled.class})
class HibernateSearchStandaloneProcessor {
    private static final Logger LOG = Logger.getLogger(HibernateSearchStandaloneProcessor.class);

    HibernateSearchStandaloneProcessor() {
    }

    @BuildStep
    void registerAnnotations(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{HibernateSearchTypes.SEARCH_EXTENSION.toString()}).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HibernateSearchTypes.SEARCH_EXTENSION, DotNames.APPLICATION_SCOPED, false));
    }

    @BuildStep
    public void configure(CombinedIndexBuildItem combinedIndexBuildItem, HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<HibernateSearchStandaloneEnabledBuildItem> enabled) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection indexedAnnotations = index.getAnnotations(HibernateSearchTypes.INDEXED);
        if (indexedAnnotations.isEmpty()) {
            return;
        }
        this.registerReflectionForGson(reflectiveClass);
        LinkedHashSet<String> backendNamesForIndexedEntities = new LinkedHashSet<String>();
        for (AnnotationInstance indexedAnnotation : indexedAnnotations) {
            AnnotationValue backendNameValue = indexedAnnotation.value("backend");
            String backendName = backendNameValue == null ? null : backendNameValue.asString();
            backendNamesForIndexedEntities.add(backendName);
        }
        Map<String, Set<String>> backendAndIndexNamesForSearchExtensions = HibernateSearchStandaloneProcessor.collectBackendAndIndexNamesForSearchExtensions(index);
        Set<String> rootAnnotationMappedClassNames = HibernateSearchStandaloneProcessor.collectRootAnnotationMappedClassNames(index);
        enabled.produce((BuildItem)new HibernateSearchStandaloneEnabledBuildItem(backendNamesForIndexedEntities, backendAndIndexNamesForSearchExtensions, rootAnnotationMappedClassNames));
    }

    private static Map<String, Set<String>> collectBackendAndIndexNamesForSearchExtensions(IndexView index) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (AnnotationInstance annotation : index.getAnnotations(HibernateSearchTypes.SEARCH_EXTENSION)) {
            AnnotationValue backendName = annotation.value("backend");
            AnnotationValue indexName = annotation.value("index");
            Set indexNames = result.computeIfAbsent(backendName == null ? null : backendName.asString(), ignored -> new LinkedHashSet());
            if (indexName == null) continue;
            indexNames.add(indexName.asString());
        }
        return result;
    }

    private static Set<String> collectRootAnnotationMappedClassNames(IndexView index) {
        LinkedHashSet<DotName> rootMappingAnnotationNames = new LinkedHashSet<DotName>(HibernateSearchTypes.BUILT_IN_ROOT_MAPPING_ANNOTATIONS);
        rootMappingAnnotationNames.add(HibernateSearchTypes.INDEXED);
        for (AnnotationInstance rootMappingAnnotationInstance : index.getAnnotations(HibernateSearchTypes.ROOT_MAPPING)) {
            rootMappingAnnotationNames.add(rootMappingAnnotationInstance.target().asClass().name());
        }
        LinkedHashSet<String> rootAnnotationMappedClassNames = new LinkedHashSet<String>();
        for (DotName rootMappingAnnotationName : rootMappingAnnotationNames) {
            for (AnnotationInstance annotation : index.getAnnotations(rootMappingAnnotationName)) {
                rootAnnotationMappedClassNames.add(JandexUtil.getEnclosingClass((AnnotationInstance)annotation).name().toString());
            }
        }
        return rootAnnotationMappedClassNames;
    }

    @BuildStep
    public void processBuildTimeConfig(Optional<HibernateSearchStandaloneEnabledBuildItem> enabled, HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (enabled.isEmpty()) {
            return;
        }
        LinkedHashSet<String> propertyKeysWithNoVersion = new LinkedHashSet<String>();
        Map backends = buildTimeConfig != null ? buildTimeConfig.backends() : Collections.emptyMap();
        LinkedHashSet<String> allBackendNames = new LinkedHashSet<String>(enabled.get().getBackendNamesForIndexedEntities());
        allBackendNames.addAll(backends.keySet());
        for (String backendName : allBackendNames) {
            HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig backendConfig = (HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig)backends.get(backendName);
            if (backendConfig == null || backendConfig.version().isEmpty()) {
                propertyKeysWithNoVersion.add(HibernateSearchStandaloneRuntimeConfig.elasticsearchVersionPropertyKey((String)backendName));
            }
            if (backendConfig == null) continue;
            HibernateSearchStandaloneProcessor.registerClasspathFileFromBackendConfig(backendName, backendConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
        if (!propertyKeysWithNoVersion.isEmpty()) {
            throw new ConfigurationException("The Elasticsearch version needs to be defined via properties: " + String.join((CharSequence)", ", propertyKeysWithNoVersion) + ".", propertyKeysWithNoVersion);
        }
    }

    private static void registerClasspathFileFromBackendConfig(String backendName, HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig backendConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchStandaloneProcessor.registerClasspathFileFromIndexConfig(backendName, null, backendConfig.indexDefaults(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        for (Map.Entry entry : backendConfig.indexes().entrySet()) {
            String indexName = (String)entry.getKey();
            HibernateSearchStandaloneBuildTimeConfig.ElasticsearchIndexBuildTimeConfig indexConfig = (HibernateSearchStandaloneBuildTimeConfig.ElasticsearchIndexBuildTimeConfig)entry.getValue();
            HibernateSearchStandaloneProcessor.registerClasspathFileFromIndexConfig(backendName, indexName, indexConfig, applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        }
    }

    private static void registerClasspathFileFromIndexConfig(String backendName, String indexName, HibernateSearchStandaloneBuildTimeConfig.ElasticsearchIndexBuildTimeConfig indexConfig, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        HibernateSearchStandaloneProcessor.registerClasspathFileFromConfig(backendName, indexName, "schema-management.settings-file", indexConfig.schemaManagement().settingsFile(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
        HibernateSearchStandaloneProcessor.registerClasspathFileFromConfig(backendName, indexName, "schema-management.mapping-file", indexConfig.schemaManagement().mappingFile(), applicationArchivesBuildItem, nativeImageResources, hotDeploymentWatchedFiles);
    }

    private static void registerClasspathFileFromConfig(String backendName, String indexName, String propertyKeyRadical, Optional<String> classpathFileOptional, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles) {
        if (!classpathFileOptional.isPresent()) {
            return;
        }
        String classpathFile = classpathFileOptional.get();
        Path existingPath = applicationArchivesBuildItem.getRootArchive().getChildPath(classpathFile);
        if (existingPath == null || Files.isDirectory(existingPath, new LinkOption[0])) {
            throw new ConfigurationException("Unable to find file referenced in '" + HibernateSearchStandaloneRuntimeConfig.backendPropertyKey((String)backendName, (String)indexName, (String)propertyKeyRadical) + "=" + classpathFile + "'. Remove property or add file to your path.");
        }
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{classpathFile}));
        hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(classpathFile));
    }

    private void registerReflectionForGson(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        String[] reflectiveClasses = (String[])GsonClasses.typesRequiringReflection().toArray(String[]::new);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])reflectiveClasses).methods().fields().build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void defineSearchMappingBean(Optional<HibernateSearchStandaloneEnabledBuildItem> enabled, HibernateSearchStandaloneRecorder recorder, HibernateSearchStandaloneRuntimeConfig runtimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (!enabled.isPresent()) {
            return;
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SearchMapping.class).scope(ApplicationScoped.class)).unremovable()).addQualifier(Default.class)).setRuntimeInit().createWith(recorder.createSearchMappingFunction(runtimeConfig, enabled.get().getBackendAndIndexNamesForSearchExtensions())).destroyer(BeanDestroyer.AutoCloseableDestroyer.class)).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    @Consume(value=BeanContainerBuildItem.class)
    public void preBoot(Optional<HibernateSearchStandaloneEnabledBuildItem> enabled, RecorderContext recorderContext, HibernateSearchStandaloneRecorder recorder, HibernateSearchStandaloneBuildTimeConfig buildTimeConfig) {
        if (enabled.isEmpty()) {
            return;
        }
        recorderContext.registerSubstitution(ElasticsearchVersion.class, String.class, ElasticsearchVersionSubstitution.class);
        recorder.preBoot(buildTimeConfig, enabled.get().getBackendAndIndexNamesForSearchExtensions(), enabled.get().getRootAnnotationMappedClassNames());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=BeanContainerBuildItem.class)
    void boot(Optional<HibernateSearchStandaloneEnabledBuildItem> enabled, HibernateSearchStandaloneRecorder recorder, HibernateSearchStandaloneRuntimeConfig runtimeConfig, BuildProducer<ServiceStartBuildItem> serviceStart) {
        if (enabled.isEmpty()) {
            return;
        }
        recorder.bootEagerly(runtimeConfig);
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("Hibernate Search Standalone"));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    void devServices(Optional<HibernateSearchStandaloneEnabledBuildItem> enabled, HibernateSearchStandaloneBuildTimeConfig buildTimeConfig, BuildProducer<DevservicesElasticsearchBuildItem> buildItemBuildProducer, BuildProducer<DevServicesAdditionalConfigBuildItem> devServicesAdditionalConfigProducer) {
        String schemaManagementStrategyPropertyKey;
        if (enabled.isEmpty()) {
            return;
        }
        HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig defaultBackendConfig = (HibernateSearchStandaloneBuildTimeConfig.ElasticsearchBackendBuildTimeConfig)buildTimeConfig.backends().get(null);
        if (defaultBackendConfig == null || !defaultBackendConfig.version().isPresent()) {
            return;
        }
        Optional active = ConfigUtils.getFirstOptionalValue((List)HibernateSearchStandaloneRuntimeConfig.mapperPropertyKeys((String)"active"), Boolean.class);
        if (active.isPresent() && !((Boolean)active.get()).booleanValue()) {
            return;
        }
        ElasticsearchVersion version = (ElasticsearchVersion)defaultBackendConfig.version().get();
        String hostsPropertyKey = HibernateSearchStandaloneRuntimeConfig.backendPropertyKey(null, null, (String)"hosts");
        buildItemBuildProducer.produce((BuildItem)new DevservicesElasticsearchBuildItem(hostsPropertyKey, version.versionString(), ElasticsearchDevServicesBuildTimeConfig.Distribution.valueOf((String)version.distribution().toString().toUpperCase())));
        List propertyKeysIndicatingHostsConfigured = HibernateSearchStandaloneRuntimeConfig.defaultBackendPropertyKeys((String)"hosts");
        if (!ConfigUtils.isAnyPropertyPresent((Collection)propertyKeysIndicatingHostsConfigured) && !ConfigUtils.isPropertyPresent((String)(schemaManagementStrategyPropertyKey = HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey((String)"schema-management.strategy")))) {
            devServicesAdditionalConfigProducer.produce((BuildItem)new DevServicesAdditionalConfigBuildItem(devServicesConfig -> {
                if (propertyKeysIndicatingHostsConfigured.stream().anyMatch(devServicesConfig::containsKey)) {
                    String forcedValue = "drop-and-create-and-drop";
                    LOG.infof("Setting %s=%s to initialize Dev Services managed Elasticsearch server", (Object)schemaManagementStrategyPropertyKey, (Object)forcedValue);
                    return Map.of(schemaManagementStrategyPropertyKey, forcedValue);
                }
                return Map.of();
            }));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={HibernateSearchStandaloneManagementEnabled.class})
    void createManagementRoutes(BuildProducer<RouteBuildItem> routes, HibernateSearchStandaloneRecorder recorder, HibernateSearchStandaloneManagementConfig managementConfig) {
        routes.produce((BuildItem)RouteBuildItem.newManagementRoute((String)(managementConfig.rootPath() + (managementConfig.rootPath().endsWith("/") ? "" : "/") + "reindex")).withRoutePathConfigKey("quarkus.hibernate-search-standalone.management.root-path").withRequestHandler(recorder.managementHandler()).displayOnNotFoundPage().build());
    }
}

