/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.util.common.SearchException;

@ConfigMapping(prefix="quarkus.hibernate-search-standalone")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface HibernateSearchStandaloneRuntimeConfig {
    public Optional<Boolean> active();

    @WithName(value="elasticsearch")
    @WithUnnamedKey
    public Map<String, ElasticsearchBackendRuntimeConfig> backends();

    public SchemaManagementConfig schemaManagement();

    public IndexingConfig indexing();

    public static String elasticsearchVersionPropertyKey(String backendName) {
        return HibernateSearchStandaloneRuntimeConfig.backendPropertyKey(backendName, null, "version");
    }

    public static String extensionPropertyKey(String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-standalone.");
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static String mapperPropertyKey(String radical) {
        return "quarkus.hibernate-search-standalone." + radical;
    }

    public static List<String> mapperPropertyKeys(String radical) {
        return List.of(HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey(radical));
    }

    public static String backendPropertyKey(String backendName, String indexName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-standalone.");
        keyBuilder.append("elasticsearch.");
        if (backendName != null) {
            keyBuilder.append("\"").append(backendName).append("\".");
        }
        if (indexName != null) {
            keyBuilder.append("indexes.\"").append(indexName).append("\".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static List<String> defaultBackendPropertyKeys(String radical) {
        return HibernateSearchStandaloneRuntimeConfig.mapperPropertyKeys("elasticsearch." + radical);
    }

    @ConfigGroup
    public static interface ElasticsearchIndexIndexingConfig {
        public OptionalInt queueCount();

        public OptionalInt queueSize();

        public OptionalInt maxBulkSize();
    }

    @ConfigGroup
    public static interface ElasticsearchIndexSchemaManagementConfig {
        public Optional<IndexStatus> requiredStatus();

        public Optional<Duration> requiredStatusWaitTimeout();
    }

    @ConfigGroup
    public static interface ElasticsearchQueryShardFailureConfig {
        @WithDefault(value="false")
        public boolean ignore();
    }

    @ConfigGroup
    public static interface ElasticsearchQueryConfig {
        public ElasticsearchQueryShardFailureConfig shardFailure();
    }

    @ConfigGroup
    public static interface ThreadPoolConfig {
        public OptionalInt size();
    }

    @ConfigGroup
    public static interface SchemaManagementConfig {
        @WithDefault(value="create-or-validate")
        public SchemaManagementStrategyName strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanSynchronizationConfig {
        public Optional<String> strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanConfig {
        public IndexingPlanSynchronizationConfig synchronization();
    }

    @ConfigGroup
    public static interface IndexingConfig {
        public IndexingPlanConfig plan();
    }

    @ConfigGroup
    public static interface DiscoveryConfig {
        @WithDefault(value="false")
        public Boolean enabled();

        @WithDefault(value="10S")
        public Duration refreshInterval();
    }

    @ConfigGroup
    public static interface ElasticsearchIndexRuntimeConfig {
        public ElasticsearchIndexSchemaManagementConfig schemaManagement();

        public ElasticsearchIndexIndexingConfig indexing();
    }

    @ConfigGroup
    public static interface ElasticsearchVersionCheckConfig {
        @WithDefault(value="true")
        public boolean enabled();
    }

    public static enum ElasticsearchClientProtocol {
        HTTP("http"),
        HTTPS("https");

        private final String hibernateSearchString;

        public static ElasticsearchClientProtocol of(String value) {
            return (ElasticsearchClientProtocol)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchClientProtocol.values(), ElasticsearchClientProtocol::getHibernateSearchString, (invalidValue, validValues) -> new SearchException(String.format(Locale.ROOT, "Invalid protocol: '%1$s'. Valid protocols are: %2$s.", invalidValue, validValues)), (String)value));
        }

        private ElasticsearchClientProtocol(String hibernateSearchString) {
            this.hibernateSearchString = hibernateSearchString;
        }

        public String getHibernateSearchString() {
            return this.hibernateSearchString;
        }
    }

    @ConfigGroup
    public static interface ElasticsearchBackendRuntimeConfig {
        @WithDefault(value="localhost:9200")
        public List<String> hosts();

        @WithDefault(value="http")
        public ElasticsearchClientProtocol protocol();

        public Optional<String> username();

        public Optional<String> password();

        @WithDefault(value="1S")
        public Duration connectionTimeout();

        @WithDefault(value="30S")
        public Duration readTimeout();

        public Optional<Duration> requestTimeout();

        @WithDefault(value="20")
        public int maxConnections();

        @WithDefault(value="10")
        public int maxConnectionsPerRoute();

        public DiscoveryConfig discovery();

        public ThreadPoolConfig threadPool();

        public ElasticsearchQueryConfig query();

        public ElasticsearchVersionCheckConfig versionCheck();

        @WithParentName
        public ElasticsearchIndexRuntimeConfig indexDefaults();

        public Map<String, ElasticsearchIndexRuntimeConfig> indexes();
    }
}

