/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.bean.ArcBeanHolder;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;

public class ArcBeanProvider
implements BeanProvider {
    private final ArcContainer delegate;

    public ArcBeanProvider(ArcContainer delegate) {
        this.delegate = delegate;
    }

    public void close() {
    }

    public <T> BeanHolder<T> forType(Class<T> typeReference) {
        InstanceHandle instance = this.delegate.instance(typeReference, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new BeanNotFoundException("No matching bean in CDI context for type " + instance);
        }
        return new ArcBeanHolder(instance);
    }

    public <T> BeanHolder<T> forTypeAndName(Class<T> typeReference, String nameReference) {
        InstanceHandle instance = this.delegate.instance(typeReference, new Annotation[]{NamedLiteral.of((String)nameReference)});
        if (!instance.isAvailable()) {
            throw new BeanNotFoundException("No matching bean in CDI context for type " + typeReference + " and @Named(" + nameReference + ")");
        }
        return new ArcBeanHolder(instance);
    }
}

