/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.hibernate.validator.runtime.interceptor.MethodValidated;
import io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class MethodValidatedAnnotationsTransformer
implements AnnotationsTransformer {
    private static final DotName[] JAXRS_METHOD_ANNOTATIONS = new DotName[]{DotName.createSimple((String)"javax.ws.rs.GET"), DotName.createSimple((String)"javax.ws.rs.HEAD"), DotName.createSimple((String)"javax.ws.rs.DELETE"), DotName.createSimple((String)"javax.ws.rs.OPTIONS"), DotName.createSimple((String)"javax.ws.rs.PATCH"), DotName.createSimple((String)"javax.ws.rs.POST"), DotName.createSimple((String)"javax.ws.rs.PUT")};
    private final Set<DotName> consideredAnnotations;
    private final Collection<DotName> effectiveJaxRsMethodDefiningAnnotations;

    MethodValidatedAnnotationsTransformer(Set<DotName> consideredAnnotations, Collection<DotName> additionalJaxRsMethodAnnotationsDotNames) {
        this.consideredAnnotations = consideredAnnotations;
        this.effectiveJaxRsMethodDefiningAnnotations = new ArrayList<DotName>(JAXRS_METHOD_ANNOTATIONS.length + additionalJaxRsMethodAnnotationsDotNames.size());
        this.effectiveJaxRsMethodDefiningAnnotations.addAll(Arrays.asList(JAXRS_METHOD_ANNOTATIONS));
        this.effectiveJaxRsMethodDefiningAnnotations.addAll(additionalJaxRsMethodAnnotationsDotNames);
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return AnnotationTarget.Kind.METHOD == kind;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        MethodInfo method = transformationContext.getTarget().asMethod();
        if (this.requiresValidation(method)) {
            if (this.isJaxrsMethod(method)) {
                transformationContext.transform().add(DotName.createSimple((String)JaxrsEndPointValidated.class.getName()), new AnnotationValue[0]).done();
            } else {
                transformationContext.transform().add(DotName.createSimple((String)MethodValidated.class.getName()), new AnnotationValue[0]).done();
            }
        }
    }

    private boolean requiresValidation(MethodInfo method) {
        if (method.annotations().isEmpty()) {
            return false;
        }
        for (DotName consideredAnnotation : this.consideredAnnotations) {
            if (!method.hasAnnotation(consideredAnnotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isJaxrsMethod(MethodInfo method) {
        for (DotName jaxrsMethodAnnotation : this.effectiveJaxRsMethodDefiningAnnotations) {
            if (!method.hasAnnotation(jaxrsMethodAnnotation)) continue;
            return true;
        }
        return false;
    }
}

