/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.hibernate.validator.deployment.SimpleMethodSignatureKey;
import io.quarkus.hibernate.validator.runtime.interceptor.MethodValidated;
import io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidated;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class MethodValidatedAnnotationsTransformer
implements AnnotationsTransformer {
    private static final Logger LOGGER = Logger.getLogger((String)MethodValidatedAnnotationsTransformer.class.getPackage().getName());
    private final Set<DotName> consideredAnnotations;
    private final Map<DotName, Set<SimpleMethodSignatureKey>> inheritedAnnotationsToBeValidated;
    private final Map<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods;

    MethodValidatedAnnotationsTransformer(Set<DotName> consideredAnnotations, Map<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods, Map<DotName, Set<SimpleMethodSignatureKey>> inheritedAnnotationsToBeValidated) {
        this.consideredAnnotations = consideredAnnotations;
        this.jaxRsMethods = jaxRsMethods;
        this.inheritedAnnotationsToBeValidated = inheritedAnnotationsToBeValidated;
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return AnnotationTarget.Kind.METHOD == kind;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        MethodInfo method = transformationContext.getTarget().asMethod();
        if (this.requiresValidation(method)) {
            if (Modifier.isStatic(method.flags())) {
                LOGGER.warnf("Hibernate Validator does not support constraints on static methods yet. Constraints on %s are ignored.", (Object)(method.declaringClass().name().toString() + "#" + method.toString()));
                return;
            }
            if (this.isJaxrsMethod(method)) {
                ((Transformation)transformationContext.transform().add(DotName.createSimple((String)JaxrsEndPointValidated.class.getName()), new AnnotationValue[0])).done();
            } else {
                ((Transformation)transformationContext.transform().add(DotName.createSimple((String)MethodValidated.class.getName()), new AnnotationValue[0])).done();
            }
        }
    }

    private boolean requiresValidation(MethodInfo method) {
        for (DotName consideredAnnotation : this.consideredAnnotations) {
            if (!method.hasAnnotation(consideredAnnotation)) continue;
            return true;
        }
        ClassInfo clazz = method.declaringClass();
        SimpleMethodSignatureKey signatureKey = new SimpleMethodSignatureKey(method);
        for (Map.Entry<DotName, Set<SimpleMethodSignatureKey>> validatedMethod : this.inheritedAnnotationsToBeValidated.entrySet()) {
            DotName ifaceOrSuperClass = validatedMethod.getKey();
            if (!clazz.interfaceNames().contains(ifaceOrSuperClass) && !ifaceOrSuperClass.equals((Object)clazz.superName()) || !validatedMethod.getValue().contains(signatureKey)) continue;
            return true;
        }
        return false;
    }

    private boolean isJaxrsMethod(MethodInfo method) {
        SimpleMethodSignatureKey signatureKey = new SimpleMethodSignatureKey(method);
        ClassInfo clazz = method.declaringClass();
        if (this.isJaxrsMethod(signatureKey, clazz.name())) {
            return true;
        }
        for (DotName iface : clazz.interfaceNames()) {
            if (!this.isJaxrsMethod(signatureKey, iface)) continue;
            return true;
        }
        DotName superClass = clazz.superName();
        return !superClass.equals((Object)IndexingUtil.OBJECT) && this.isJaxrsMethod(signatureKey, superClass);
    }

    private boolean isJaxrsMethod(SimpleMethodSignatureKey signatureKey, DotName dotName) {
        Set<SimpleMethodSignatureKey> signatureKeys = this.jaxRsMethods.get(dotName);
        return signatureKeys != null && signatureKeys.contains(signatureKey);
    }
}

