/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.validator.deployment.MethodValidatedAnnotationsTransformer;
import io.quarkus.hibernate.validator.deployment.SimpleMethodSignatureKey;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorBuildTimeConfig;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorRecorder;
import io.quarkus.hibernate.validator.runtime.ValidatorProvider;
import io.quarkus.hibernate.validator.runtime.interceptor.MethodValidationInterceptor;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.validation.ClockProvider;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Valid;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class HibernateValidatorProcessor {
    private static final String META_INF_VALIDATION_XML = "META-INF/validation.xml";
    private static final DotName CONSTRAINT_VALIDATOR_FACTORY = DotName.createSimple((String)ConstraintValidatorFactory.class.getName());
    private static final DotName MESSAGE_INTERPOLATOR = DotName.createSimple((String)MessageInterpolator.class.getName());
    private static final DotName LOCALE_RESOLVER = DotName.createSimple((String)LocaleResolver.class.getName());
    private static final DotName TRAVERSABLE_RESOLVER = DotName.createSimple((String)TraversableResolver.class.getName());
    private static final DotName PARAMETER_NAME_PROVIDER = DotName.createSimple((String)ParameterNameProvider.class.getName());
    private static final DotName CLOCK_PROVIDER = DotName.createSimple((String)ClockProvider.class.getName());
    private static final DotName SCRIPT_EVALUATOR_FACTORY = DotName.createSimple((String)ScriptEvaluatorFactory.class.getName());
    private static final DotName GETTER_PROPERTY_SELECTION_STRATEGY = DotName.createSimple((String)GetterPropertySelectionStrategy.class.getName());
    private static final DotName CONSTRAINT_VALIDATOR = DotName.createSimple((String)ConstraintValidator.class.getName());
    private static final DotName VALUE_EXTRACTOR = DotName.createSimple((String)ValueExtractor.class.getName());
    private static final DotName VALIDATE_ON_EXECUTION = DotName.createSimple((String)ValidateOnExecution.class.getName());
    private static final DotName VALID = DotName.createSimple((String)Valid.class.getName());
    private static final DotName REPEATABLE = DotName.createSimple((String)Repeatable.class.getName());
    private static final Pattern BUILT_IN_CONSTRAINT_REPEATABLE_CONTAINER_PATTERN = Pattern.compile("\\$List$");

    HibernateValidatorProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.HIBERNATE_VALIDATOR);
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem configFile() {
        return new HotDeploymentWatchedFileBuildItem(META_INF_VALIDATION_XML);
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("org.hibernate.validator.internal.util.Version", new String[]{"HV000001:"});
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBean, BuildProducer<AutoAddScopeBuildItem> autoScopes, Capabilities capabilities) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ValidatorProvider.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MethodValidationInterceptor.class}));
        if (capabilities.isPresent(Capability.RESTEASY)) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidationInterceptor"}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyContextLocaleResolver"}));
        }
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(CONSTRAINT_VALIDATOR).requiresContainerServices().defaultScope(BuiltinScope.SINGLETON).build());
        unremovableBean.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                return beanInfo.hasType(CONSTRAINT_VALIDATOR) || beanInfo.hasType(CONSTRAINT_VALIDATOR_FACTORY) || beanInfo.hasType(MESSAGE_INTERPOLATOR) || beanInfo.hasType(TRAVERSABLE_RESOLVER) || beanInfo.hasType(PARAMETER_NAME_PROVIDER) || beanInfo.hasType(CLOCK_PROVIDER) || beanInfo.hasType(VALUE_EXTRACTOR) || beanInfo.hasType(SCRIPT_EVALUATOR_FACTORY) || beanInfo.hasType(GETTER_PROPERTY_SELECTION_STRATEGY) || beanInfo.hasType(LOCALE_RESOLVER);
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateValidatorRecorder recorder, RecorderContext recorderContext, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, ShutdownContextBuildItem shutdownContext, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations, Capabilities capabilities, LocalesBuildTimeConfig localesBuildTimeConfig, HibernateValidatorBuildTimeConfig hibernateValidatorBuildTimeConfig) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_VALIDATOR));
        CompositeIndex indexView = CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndexBuildItem.getIndex(), combinedIndexBuildItem.getIndex()});
        HashSet<DotName> consideredAnnotations = new HashSet<DotName>();
        Set builtinConstraints = ConstraintHelper.getBuiltinConstraints();
        HibernateValidatorProcessor.contributeBuiltinConstraints(builtinConstraints, consideredAnnotations);
        for (AnnotationInstance constraint : indexView.getAnnotations(DotName.createSimple((String)Constraint.class.getName()))) {
            consideredAnnotations.add(constraint.target().asClass().name());
            if (!constraint.target().asClass().annotations().containsKey(REPEATABLE)) continue;
            for (AnnotationInstance repeatableConstraint : (List)constraint.target().asClass().annotations().get(REPEATABLE)) {
                consideredAnnotations.add(repeatableConstraint.value().asClass().name());
            }
        }
        consideredAnnotations.add(VALID);
        consideredAnnotations.add(VALIDATE_ON_EXECUTION);
        HashSet<DotName> classNamesToBeValidated = new HashSet<DotName>();
        HashMap<DotName, Set<SimpleMethodSignatureKey>> inheritedAnnotationsToBeValidated = new HashMap<DotName, Set<SimpleMethodSignatureKey>>();
        HashSet<String> detectedBuiltinConstraints = new HashSet<String>();
        for (DotName consideredAnnotation : consideredAnnotations) {
            Collection annotationInstances = indexView.getAnnotations(consideredAnnotation);
            if (annotationInstances.isEmpty()) continue;
            String builtinConstraintCandidate = BUILT_IN_CONSTRAINT_REPEATABLE_CONTAINER_PATTERN.matcher(consideredAnnotation.toString()).replaceAll("");
            if (builtinConstraints.contains(builtinConstraintCandidate)) {
                detectedBuiltinConstraints.add(builtinConstraintCandidate);
            }
            for (AnnotationInstance annotation : annotationInstances) {
                if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asField().declaringClass().name());
                    reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(annotation.target().asField()));
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asField().type());
                    continue;
                }
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asMethod().declaringClass().name());
                    reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(annotation.target().asMethod()));
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asMethod().returnType());
                    HibernateValidatorProcessor.contributeMethodsWithInheritedValidation(inheritedAnnotationsToBeValidated, (IndexView)indexView, annotation.target().asMethod());
                    continue;
                }
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asMethodParameter().method().declaringClass().name());
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, (Type)annotation.target().asMethodParameter().method().parameters().get(annotation.target().asMethodParameter().position()));
                    HibernateValidatorProcessor.contributeMethodsWithInheritedValidation(inheritedAnnotationsToBeValidated, (IndexView)indexView, annotation.target().asMethodParameter().method());
                    continue;
                }
                if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asClass().name());
            }
        }
        Map<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods = HibernateValidatorProcessor.gatherJaxRsMethods(additionalJaxRsResourceMethodAnnotations, (IndexView)indexView);
        annotationsTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new MethodValidatedAnnotationsTransformer(consideredAnnotations, jaxRsMethods, inheritedAnnotationsToBeValidated)));
        HashSet<Class> classesToBeValidated = new HashSet<Class>();
        for (DotName className : classNamesToBeValidated) {
            classesToBeValidated.add(recorderContext.classProxy(className.toString()));
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initializeValidatorFactory(classesToBeValidated, detectedBuiltinConstraints, HibernateValidatorProcessor.hasXmlConfiguration(), capabilities.isPresent(Capability.HIBERNATE_ORM), (ShutdownContext)shutdownContext, localesBuildTimeConfig, hibernateValidatorBuildTimeConfig)));
    }

    @BuildStep
    NativeImageConfigBuildItem nativeImageConfig() {
        return NativeImageConfigBuildItem.builder().addResourceBundle("org.hibernate.validator.ValidationMessages").addResourceBundle("ValidationMessages").addResourceBundle("ContributorValidationMessages").build();
    }

    private static void contributeBuiltinConstraints(Set<String> builtinConstraints, Set<DotName> consideredAnnotationsCollector) {
        for (String builtinConstraint : builtinConstraints) {
            consideredAnnotationsCollector.add(DotName.createSimple((String)builtinConstraint));
            consideredAnnotationsCollector.add(DotName.createSimple((String)(builtinConstraint + "$List")));
        }
    }

    private static void contributeClass(Set<DotName> classNamesCollector, IndexView indexView, DotName className) {
        classNamesCollector.add(className);
        for (ClassInfo subclass : indexView.getAllKnownSubclasses(className)) {
            if (Modifier.isAbstract(subclass.flags())) continue;
            classNamesCollector.add(subclass.name());
        }
        for (ClassInfo implementor : indexView.getAllKnownImplementors(className)) {
            if (Modifier.isAbstract(implementor.flags())) continue;
            classNamesCollector.add(implementor.name());
        }
    }

    private static void contributeClassMarkedForCascadingValidation(Set<DotName> classNamesCollector, IndexView indexView, DotName consideredAnnotation, Type type) {
        if (VALID != consideredAnnotation) {
            return;
        }
        DotName className = HibernateValidatorProcessor.getClassName(type);
        if (className != null) {
            HibernateValidatorProcessor.contributeClass(classNamesCollector, indexView, className);
        }
    }

    private static void contributeMethodsWithInheritedValidation(Map<DotName, Set<SimpleMethodSignatureKey>> inheritedAnnotationsToBeValidated, IndexView indexView, MethodInfo method) {
        ClassInfo clazz = method.declaringClass();
        if (Modifier.isInterface(clazz.flags())) {
            inheritedAnnotationsToBeValidated.computeIfAbsent(clazz.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
        }
    }

    private static Map<DotName, Set<SimpleMethodSignatureKey>> gatherJaxRsMethods(List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations, IndexView indexView) {
        HashMap<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods = new HashMap<DotName, Set<SimpleMethodSignatureKey>>();
        ArrayList jaxRsMethodDefiningAnnotations = new ArrayList(ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS.size() + additionalJaxRsResourceMethodAnnotations.size());
        jaxRsMethodDefiningAnnotations.addAll(ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS);
        for (AdditionalJaxRsResourceMethodAnnotationsBuildItem additionalJaxRsResourceMethodAnnotation : additionalJaxRsResourceMethodAnnotations) {
            jaxRsMethodDefiningAnnotations.addAll(additionalJaxRsResourceMethodAnnotation.getAnnotationClasses());
        }
        for (DotName jaxRsAnnotation : jaxRsMethodDefiningAnnotations) {
            Collection annotationInstances = indexView.getAnnotations(jaxRsAnnotation);
            if (annotationInstances.isEmpty()) continue;
            for (AnnotationInstance annotation : annotationInstances) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo method = annotation.target().asMethod();
                jaxRsMethods.computeIfAbsent(method.declaringClass().name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
            }
        }
        return jaxRsMethods;
    }

    private static DotName getClassName(Type type) {
        switch (type.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                return type.name();
            }
            case ARRAY: {
                return HibernateValidatorProcessor.getClassName(type.asArrayType().component());
            }
        }
        return null;
    }

    private static boolean hasXmlConfiguration() {
        return Thread.currentThread().getContextClassLoader().getResource(META_INF_VALIDATION_XML) != null;
    }
}

