/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.hibernate.validator.ValidatorFactoryCustomizer;
import io.quarkus.hibernate.validator.deployment.MethodValidatedAnnotationsTransformer;
import io.quarkus.hibernate.validator.deployment.SimpleMethodSignatureKey;
import io.quarkus.hibernate.validator.runtime.DisableLoggingFeature;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorBuildTimeConfig;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorRecorder;
import io.quarkus.hibernate.validator.runtime.ValidationSupport;
import io.quarkus.hibernate.validator.runtime.ValidatorProvider;
import io.quarkus.hibernate.validator.runtime.interceptor.MethodValidationInterceptor;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveViolationExceptionMapper;
import io.quarkus.hibernate.validator.runtime.jaxrs.ViolationReport;
import io.quarkus.hibernate.validator.spi.BeanValidationAnnotationsBuildItem;
import io.quarkus.jaxrs.spi.deployment.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyConfigBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import jakarta.inject.Singleton;
import jakarta.validation.ClockProvider;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class HibernateValidatorProcessor {
    private static final String META_INF_VALIDATION_XML = "META-INF/validation.xml";
    private static final DotName CONSTRAINT_VALIDATOR_FACTORY = DotName.createSimple((String)ConstraintValidatorFactory.class.getName());
    private static final DotName MESSAGE_INTERPOLATOR = DotName.createSimple((String)MessageInterpolator.class.getName());
    private static final DotName LOCALE_RESOLVER = DotName.createSimple((String)LocaleResolver.class.getName());
    private static final DotName TRAVERSABLE_RESOLVER = DotName.createSimple((String)TraversableResolver.class.getName());
    private static final DotName PARAMETER_NAME_PROVIDER = DotName.createSimple((String)ParameterNameProvider.class.getName());
    private static final DotName CLOCK_PROVIDER = DotName.createSimple((String)ClockProvider.class.getName());
    private static final DotName SCRIPT_EVALUATOR_FACTORY = DotName.createSimple((String)ScriptEvaluatorFactory.class.getName());
    private static final DotName GETTER_PROPERTY_SELECTION_STRATEGY = DotName.createSimple((String)GetterPropertySelectionStrategy.class.getName());
    private static final DotName PROPERTY_NODE_NAME_PROVIDER = DotName.createSimple((String)PropertyNodeNameProvider.class.getName());
    private static final DotName VALIDATOR_FACTORY_CUSTOMIZER = DotName.createSimple((String)ValidatorFactoryCustomizer.class.getName());
    private static final DotName CONSTRAINT_VALIDATOR = DotName.createSimple((String)ConstraintValidator.class.getName());
    private static final DotName VALUE_EXTRACTOR = DotName.createSimple((String)ValueExtractor.class.getName());
    private static final DotName VALIDATE_ON_EXECUTION = DotName.createSimple((String)ValidateOnExecution.class.getName());
    private static final DotName VALID = DotName.createSimple((String)Valid.class.getName());
    private static final DotName REPEATABLE = DotName.createSimple((String)Repeatable.class.getName());
    private static final Pattern BUILT_IN_CONSTRAINT_REPEATABLE_CONTAINER_PATTERN = Pattern.compile("\\$List$");

    HibernateValidatorProcessor() {
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem configFile() {
        return new HotDeploymentWatchedFileBuildItem(META_INF_VALIDATION_XML);
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("org.hibernate.validator.internal.util.Version", new String[]{"HV000001:"});
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(DisableLoggingFeature.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerAdditionalBeans(HibernateValidatorRecorder hibernateValidatorRecorder, Optional<ResteasyConfigBuildItem> resteasyConfigBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBean, BuildProducer<AutoAddScopeBuildItem> autoScopes, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItems, Capabilities capabilities) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ValidatorProvider.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{MethodValidationInterceptor.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.locale.LocaleResolversWrapper"}));
        if (capabilities.isPresent("io.quarkus.resteasy")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.jaxrs.JaxrsEndPointValidationInterceptor"}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.locale.ResteasyClassicLocaleResolver"}));
            syntheticBeanBuildItems.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ResteasyConfigSupport.class).scope(Singleton.class)).unremovable()).supplier(hibernateValidatorRecorder.resteasyConfigSupportSupplier(resteasyConfigBuildItem.isPresent() ? resteasyConfigBuildItem.get().isJsonDefault() : false)).done());
        } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveEndPointValidationInterceptor"}));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"io.quarkus.hibernate.validator.runtime.locale.ResteasyReactiveLocaleResolver"}));
        }
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(CONSTRAINT_VALIDATOR).requiresContainerServices().defaultScope(BuiltinScope.DEPENDENT).build());
        unremovableBean.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                return beanInfo.hasType(CONSTRAINT_VALIDATOR) || beanInfo.hasType(CONSTRAINT_VALIDATOR_FACTORY) || beanInfo.hasType(MESSAGE_INTERPOLATOR) || beanInfo.hasType(TRAVERSABLE_RESOLVER) || beanInfo.hasType(PARAMETER_NAME_PROVIDER) || beanInfo.hasType(CLOCK_PROVIDER) || beanInfo.hasType(SCRIPT_EVALUATOR_FACTORY) || beanInfo.hasType(GETTER_PROPERTY_SELECTION_STRATEGY) || beanInfo.hasType(LOCALE_RESOLVER) || beanInfo.hasType(PROPERTY_NODE_NAME_PROVIDER) || beanInfo.hasType(VALIDATOR_FACTORY_CUSTOMIZER);
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateValidatorRecorder recorder, RecorderContext recorderContext, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, BuildProducer<BeanValidationAnnotationsBuildItem> beanValidationAnnotations, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, ShutdownContextBuildItem shutdownContext, List<ConfigClassBuildItem> configClasses, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations, Capabilities capabilities, LocalesBuildTimeConfig localesBuildTimeConfig, HibernateValidatorBuildTimeConfig hibernateValidatorBuildTimeConfig) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_VALIDATOR));
        CompositeIndex indexView = CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndexBuildItem.getIndex(), combinedIndexBuildItem.getIndex()});
        HashSet<DotName> constraints = new HashSet<DotName>();
        Set builtinConstraints = ConstraintHelper.getBuiltinConstraints();
        HibernateValidatorProcessor.contributeBuiltinConstraints(builtinConstraints, constraints);
        for (AnnotationInstance constraint : indexView.getAnnotations(DotName.createSimple((String)Constraint.class.getName()))) {
            constraints.add(constraint.target().asClass().name());
            if (!constraint.target().asClass().annotationsMap().containsKey(REPEATABLE)) continue;
            for (AnnotationInstance repeatableConstraint : (List)constraint.target().asClass().annotationsMap().get(REPEATABLE)) {
                constraints.add(repeatableConstraint.value().asClass().name());
            }
        }
        HashSet<DotName> allConsideredAnnotations = new HashSet<DotName>();
        allConsideredAnnotations.addAll(constraints);
        allConsideredAnnotations.add(VALID);
        allConsideredAnnotations.add(VALIDATE_ON_EXECUTION);
        beanValidationAnnotations.produce((BuildItem)new BeanValidationAnnotationsBuildItem(VALID, constraints, allConsideredAnnotations));
        HashSet<DotName> classNamesToBeValidated = new HashSet<DotName>();
        HashMap<DotName, Set<SimpleMethodSignatureKey>> methodsWithInheritedValidation = new HashMap<DotName, Set<SimpleMethodSignatureKey>>();
        HashSet<String> detectedBuiltinConstraints = new HashSet<String>();
        for (DotName consideredAnnotation : allConsideredAnnotations) {
            Collection annotationInstances = indexView.getAnnotations(consideredAnnotation);
            if (annotationInstances.isEmpty()) continue;
            String builtinConstraintCandidate = BUILT_IN_CONSTRAINT_REPEATABLE_CONTAINER_PATTERN.matcher(consideredAnnotation.toString()).replaceAll("");
            if (builtinConstraints.contains(builtinConstraintCandidate)) {
                detectedBuiltinConstraints.add(builtinConstraintCandidate);
            }
            Iterator iterator = annotationInstances.iterator();
            while (iterator.hasNext()) {
                AnnotationInstance annotation = (AnnotationInstance)iterator.next();
                if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asField().declaringClass().name());
                    reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(annotation.target().asField()));
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asField().type());
                    continue;
                }
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asMethod().declaringClass().name());
                    reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(annotation.target().asMethod()));
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asMethod().returnType());
                    HibernateValidatorProcessor.contributeMethodsWithInheritedValidation(methodsWithInheritedValidation, (IndexView)indexView, annotation.target().asMethod());
                    continue;
                }
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asMethodParameter().method().declaringClass().name());
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, (Type)annotation.target().asMethodParameter().method().parameterTypes().get(annotation.target().asMethodParameter().position()));
                    HibernateValidatorProcessor.contributeMethodsWithInheritedValidation(methodsWithInheritedValidation, (IndexView)indexView, annotation.target().asMethodParameter().method());
                    continue;
                }
                if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, annotation.target().asClass().name());
                    continue;
                }
                if (annotation.target().kind() != AnnotationTarget.Kind.TYPE) continue;
                AnnotationTarget enclosingTarget = annotation.target().asType().enclosingTarget();
                if (enclosingTarget.kind() == AnnotationTarget.Kind.FIELD) {
                    HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, enclosingTarget.asField().declaringClass().name());
                    reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(enclosingTarget.asField()));
                    if (annotation.target().asType().target() == null) continue;
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asType().target());
                    continue;
                }
                if (enclosingTarget.kind() != AnnotationTarget.Kind.METHOD) continue;
                HibernateValidatorProcessor.contributeClass(classNamesToBeValidated, (IndexView)indexView, enclosingTarget.asMethod().declaringClass().name());
                reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(enclosingTarget.asMethod()));
                if (annotation.target().asType().target() != null) {
                    HibernateValidatorProcessor.contributeClassMarkedForCascadingValidation(classNamesToBeValidated, (IndexView)indexView, consideredAnnotation, annotation.target().asType().target());
                }
                HibernateValidatorProcessor.contributeMethodsWithInheritedValidation(methodsWithInheritedValidation, (IndexView)indexView, enclosingTarget.asMethod());
            }
        }
        for (ConfigClassBuildItem configClass : configClasses) {
            for (Object generatedClass : configClass.getGeneratedClasses()) {
                classNamesToBeValidated.add(DotName.createSimple((String)generatedClass));
            }
        }
        HashSet<DotName> additional = new HashSet<DotName>();
        additionalJaxRsResourceMethodAnnotations.forEach(s -> additional.addAll(s.getAnnotationClasses()));
        Map<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods = HibernateValidatorProcessor.gatherJaxRsMethods(additional, (IndexView)indexView);
        annotationsTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new MethodValidatedAnnotationsTransformer(allConsideredAnnotations, jaxRsMethods, methodsWithInheritedValidation)));
        HashSet<Class> classesToBeValidated = new HashSet<Class>();
        for (DotName dotName : classNamesToBeValidated) {
            classesToBeValidated.add(recorderContext.classProxy(dotName.toString()));
        }
        HashSet<DotName> valueExtractorClassNames = new HashSet<DotName>();
        for (ClassInfo valueExtractorType : indexView.getAllKnownImplementors(VALUE_EXTRACTOR)) {
            valueExtractorClassNames.add(valueExtractorType.name());
        }
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(valueExtractorClassNames));
        HashSet<Class> hashSet = new HashSet<Class>();
        for (DotName className : valueExtractorClassNames) {
            hashSet.add(recorderContext.classProxy(className.toString()));
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initializeValidatorFactory(classesToBeValidated, detectedBuiltinConstraints, hashSet, HibernateValidatorProcessor.hasXmlConfiguration(), capabilities.isPresent("io.quarkus.hibernate.orm"), (ShutdownContext)shutdownContext, localesBuildTimeConfig, hibernateValidatorBuildTimeConfig)));
    }

    @BuildStep
    void optionalResourceBundles(BuildProducer<NativeImageResourceBundleBuildItem> resourceBundles) {
        String[] potentialHibernateValidatorResourceBundles;
        for (String potentialHibernateValidatorResourceBundle : potentialHibernateValidatorResourceBundles = new String[]{"org.hibernate.validator.ValidationMessages", "ValidationMessages", "ContributorValidationMessages"}) {
            if (!QuarkusClassLoader.isResourcePresentAtRuntime((String)potentialHibernateValidatorResourceBundle)) continue;
            resourceBundles.produce((BuildItem)new NativeImageResourceBundleBuildItem(potentialHibernateValidatorResourceBundle));
        }
    }

    @BuildStep
    void exceptionMapper(BuildProducer<ExceptionMapperBuildItem> exceptionMapperProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        exceptionMapperProducer.produce((BuildItem)new ExceptionMapperBuildItem(ResteasyReactiveViolationExceptionMapper.class.getName(), ValidationException.class.getName(), Integer.valueOf(5001), true));
        reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ViolationReport.class, ViolationReport.Violation.class}).methods().fields().build());
    }

    @BuildStep
    void overrideStandardValidationFactoryResolution(BuildProducer<BytecodeTransformerBuildItem> transformer) {
        BytecodeTransformerBuildItem transformation = new BytecodeTransformerBuildItem(Validation.class.getName(), (className, classVisitor) -> new ClassVisitor(589824, (ClassVisitor)classVisitor){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (name.equals("buildDefaultValidatorFactory")) {
                    return new MethodVisitor(589824, visitor){

                        public void visitCode() {
                            super.visitCode();
                            this.visitMethodInsn(184, ValidationSupport.class.getName().replace(".", "/"), "buildDefaultValidatorFactory", String.format("()L%s;", ValidatorFactory.class.getName().replace(".", "/")), false);
                            this.visitInsn(176);
                        }
                    };
                }
                return visitor;
            }
        });
        transformer.produce((BuildItem)transformation);
    }

    private static void contributeBuiltinConstraints(Set<String> builtinConstraints, Set<DotName> consideredAnnotationsCollector) {
        for (String builtinConstraint : builtinConstraints) {
            consideredAnnotationsCollector.add(DotName.createSimple((String)builtinConstraint));
            consideredAnnotationsCollector.add(DotName.createSimple((String)(builtinConstraint + "$List")));
        }
    }

    private static void contributeClass(Set<DotName> classNamesCollector, IndexView indexView, DotName className) {
        classNamesCollector.add(className);
        if (DotNames.OBJECT.equals((Object)className)) {
            return;
        }
        for (ClassInfo subclass : indexView.getAllKnownSubclasses(className)) {
            if (Modifier.isAbstract(subclass.flags())) continue;
            classNamesCollector.add(subclass.name());
        }
        for (ClassInfo implementor : indexView.getAllKnownImplementors(className)) {
            if (Modifier.isAbstract(implementor.flags())) continue;
            classNamesCollector.add(implementor.name());
        }
    }

    private static void contributeClassMarkedForCascadingValidation(Set<DotName> classNamesCollector, IndexView indexView, DotName consideredAnnotation, Type type) {
        if (VALID != consideredAnnotation) {
            return;
        }
        DotName className = HibernateValidatorProcessor.getClassName(type);
        if (className != null) {
            HibernateValidatorProcessor.contributeClass(classNamesCollector, indexView, className);
        }
    }

    private static void contributeMethodsWithInheritedValidation(Map<DotName, Set<SimpleMethodSignatureKey>> methodsWithInheritedValidation, IndexView indexView, MethodInfo method) {
        ClassInfo clazz = method.declaringClass();
        methodsWithInheritedValidation.computeIfAbsent(clazz.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
        if (Modifier.isInterface(clazz.flags())) {
            for (ClassInfo implementor : indexView.getAllKnownImplementors(clazz.name())) {
                methodsWithInheritedValidation.computeIfAbsent(implementor.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
            }
        } else {
            for (ClassInfo subclass : indexView.getAllKnownSubclasses(clazz.name())) {
                methodsWithInheritedValidation.computeIfAbsent(subclass.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
            }
        }
    }

    private static Map<DotName, Set<SimpleMethodSignatureKey>> gatherJaxRsMethods(Set<DotName> additionalJaxRsResourceMethodAnnotations, IndexView indexView) {
        HashMap<DotName, Set<SimpleMethodSignatureKey>> jaxRsMethods = new HashMap<DotName, Set<SimpleMethodSignatureKey>>();
        ArrayList<DotName> jaxRsMethodDefiningAnnotations = new ArrayList<DotName>(ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS.size() + additionalJaxRsResourceMethodAnnotations.size());
        jaxRsMethodDefiningAnnotations.addAll(ResteasyDotNames.JAXRS_METHOD_ANNOTATIONS);
        jaxRsMethodDefiningAnnotations.addAll(additionalJaxRsResourceMethodAnnotations);
        for (DotName jaxRsAnnotation : jaxRsMethodDefiningAnnotations) {
            Collection annotationInstances = indexView.getAnnotations(jaxRsAnnotation);
            if (annotationInstances.isEmpty()) continue;
            for (AnnotationInstance annotation : annotationInstances) {
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo method = annotation.target().asMethod();
                jaxRsMethods.computeIfAbsent(method.declaringClass().name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
                if (Modifier.isInterface(method.declaringClass().flags())) {
                    for (ClassInfo implementor : indexView.getAllKnownImplementors(method.declaringClass().name())) {
                        jaxRsMethods.computeIfAbsent(implementor.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
                    }
                    continue;
                }
                for (ClassInfo subclass : indexView.getAllKnownSubclasses(method.declaringClass().name())) {
                    jaxRsMethods.computeIfAbsent(subclass.name(), k -> new HashSet()).add(new SimpleMethodSignatureKey(method));
                }
            }
        }
        return jaxRsMethods;
    }

    private static DotName getClassName(Type type) {
        switch (type.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                return type.name();
            }
            case ARRAY: {
                return HibernateValidatorProcessor.getClassName(type.asArrayType().component());
            }
        }
        return null;
    }

    private static boolean hasXmlConfiguration() {
        return Thread.currentThread().getContextClassLoader().getResource(META_INF_VALIDATION_XML) != null;
    }
}

