/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.lang.annotation.Annotation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public final class ValidationSupport {
    private ValidationSupport() {
    }

    public static ValidatorFactory buildDefaultValidatorFactory() {
        ArcContainer container = Arc.container();
        if (container == null) {
            return ValidationSupport.fallback();
        }
        InstanceHandle instance = container.instance(ValidatorFactory.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            return ValidationSupport.fallback();
        }
        return (ValidatorFactory)instance.get();
    }

    private static ValidatorFactory fallback() {
        return Validation.byDefaultProvider().configure().buildValidatorFactory();
    }
}

