/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveViolationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ResteasyReactiveViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        if (!(exception instanceof ResteasyReactiveViolationException)) {
            throw exception;
        }
        ResteasyReactiveViolationException resteasyViolationException = (ResteasyReactiveViolationException)exception;
        if (this.hasReturnValueViolation(resteasyViolationException.getConstraintViolations())) {
            throw resteasyViolationException;
        }
        return this.buildViolationReportResponse(resteasyViolationException);
    }

    private boolean hasReturnValueViolation(Set<ConstraintViolation<?>> violations) {
        for (ConstraintViolation<?> violation : violations) {
            if (!this.isReturnValueViolation(violation)) continue;
            return true;
        }
        return false;
    }

    private boolean isReturnValueViolation(ConstraintViolation<?> violation) {
        Iterator nodes = violation.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        if (firstNode.getKind() != ElementKind.METHOD) {
            return false;
        }
        Path.Node secondNode = (Path.Node)nodes.next();
        return secondNode.getKind() == ElementKind.RETURN_VALUE;
    }

    protected Response buildResponse(Object entity, Response.Status status) {
        return Response.status((Response.Status)status).entity(entity).build();
    }

    private Response buildViolationReportResponse(ConstraintViolationException cve) {
        ArrayList<ViolationReport.Violation> violationsInReport = new ArrayList<ViolationReport.Violation>(cve.getConstraintViolations().size());
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            violationsInReport.add(new ViolationReport.Violation(cv.getPropertyPath().toString(), cv.getMessage()));
        }
        Response.Status status = Response.Status.BAD_REQUEST;
        return this.buildResponse(new ViolationReport("Constraint Violation", status, violationsInReport), status);
    }

    public static class ViolationReport {
        private final String title;
        private final int status;
        private final List<Violation> violations;

        public ViolationReport(String title, Response.Status status, List<Violation> violations) {
            this.title = title;
            this.status = status.getStatusCode();
            this.violations = violations;
        }

        public String getTitle() {
            return this.title;
        }

        public int getStatus() {
            return this.status;
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public static class Violation {
            private final String field;
            private final String message;

            public Violation(String field, String message) {
                this.field = field;
                this.message = message;
            }

            public String getField() {
                return this.field;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }
}

