/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveViolationException;
import io.quarkus.hibernate.validator.runtime.jaxrs.ValidatorMediaTypeUtil;
import io.quarkus.hibernate.validator.runtime.jaxrs.ViolationReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ResteasyReactiveViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    @Context
    HttpHeaders headers;

    public Response toResponse(ValidationException exception) {
        if (!(exception instanceof ResteasyReactiveViolationException)) {
            throw exception;
        }
        ResteasyReactiveViolationException resteasyViolationException = (ResteasyReactiveViolationException)exception;
        if (this.hasReturnValueViolation(resteasyViolationException.getConstraintViolations())) {
            throw resteasyViolationException;
        }
        return this.buildViolationReportResponse(resteasyViolationException);
    }

    private boolean hasReturnValueViolation(Set<ConstraintViolation<?>> violations) {
        if (violations != null) {
            for (ConstraintViolation<?> violation : violations) {
                if (!this.isReturnValueViolation(violation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReturnValueViolation(ConstraintViolation<?> violation) {
        Iterator nodes = violation.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        if (firstNode.getKind() != ElementKind.METHOD) {
            return false;
        }
        Path.Node secondNode = (Path.Node)nodes.next();
        return secondNode.getKind() == ElementKind.RETURN_VALUE;
    }

    private Response buildViolationReportResponse(ConstraintViolationException cve) {
        Response.Status status = Response.Status.BAD_REQUEST;
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        builder.header("validation-exception", (Object)"true");
        MediaType mediaType = ValidatorMediaTypeUtil.getAcceptMediaTypeFromSupported(this.headers.getAcceptableMediaTypes());
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_JSON_TYPE;
        }
        ArrayList<ViolationReport.Violation> violationsInReport = new ArrayList<ViolationReport.Violation>(cve.getConstraintViolations().size());
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            violationsInReport.add(new ViolationReport.Violation(cv.getPropertyPath().toString(), cv.getMessage()));
        }
        builder.entity((Object)new ViolationReport("Constraint Violation", status, violationsInReport));
        builder.type(mediaType);
        return builder.build();
    }
}

