/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.validator.ValidatorFactoryCustomizer;
import io.quarkus.hibernate.validator.runtime.ArcConstraintValidatorFactoryImpl;
import io.quarkus.hibernate.validator.runtime.ArcProxyBeanMetaDataClassNormalizer;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorBuildTimeConfig;
import io.quarkus.hibernate.validator.runtime.TraverseAllTraversableResolver;
import io.quarkus.hibernate.validator.runtime.ValidatorHolder;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.validator.BaseHibernateValidatorConfiguration;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.PredefinedScopeHibernateValidator;
import org.hibernate.validator.PredefinedScopeHibernateValidatorConfiguration;
import org.hibernate.validator.internal.engine.resolver.JPATraversableResolver;
import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

@Recorder
public class HibernateValidatorRecorder {
    private static final TypeLiteral<ValueExtractor<?>> TYPE_LITERAL_VALUE_EXTRACTOR_WITH_WILDCARD = new TypeLiteral<ValueExtractor<?>>(){};

    public BeanContainerListener initializeValidatorFactory(final Set<Class<?>> classesToBeValidated, final Set<String> detectedBuiltinConstraints, final boolean hasXmlConfiguration, final boolean jpaInClasspath, final ShutdownContext shutdownContext, final LocalesBuildTimeConfig localesBuildTimeConfig, final HibernateValidatorBuildTimeConfig hibernateValidatorBuildTimeConfig) {
        BeanContainerListener beanContainerListener = new BeanContainerListener(){

            public void created(BeanContainer container) {
                InstanceHandle configuredPropertyNodeNameProvider;
                InstanceHandle configuredGetterPropertySelectionStrategy;
                InstanceHandle configuredClockProvider;
                InstanceHandle configuredTraversableResolver;
                InstanceHandle configuredConstraintValidatorFactory;
                PredefinedScopeHibernateValidatorConfiguration configuration = (PredefinedScopeHibernateValidatorConfiguration)Validation.byProvider(PredefinedScopeHibernateValidator.class).configure();
                if (!hasXmlConfiguration) {
                    configuration.ignoreXmlConfiguration();
                }
                LocaleResolver localeResolver = null;
                InstanceHandle configuredLocaleResolver = Arc.container().instance("locale-resolver-wrapper");
                if (configuredLocaleResolver.isAvailable()) {
                    localeResolver = (LocaleResolver)configuredLocaleResolver.get();
                    configuration.localeResolver(localeResolver);
                }
                ((PredefinedScopeHibernateValidatorConfiguration)((PredefinedScopeHibernateValidatorConfiguration)configuration.builtinConstraints(detectedBuiltinConstraints).initializeBeanMetaData(classesToBeValidated).locales(localesBuildTimeConfig.locales)).defaultLocale(localesBuildTimeConfig.defaultLocale)).beanMetaDataClassNormalizer((BeanMetaDataClassNormalizer)new ArcProxyBeanMetaDataClassNormalizer());
                if (hibernateValidatorBuildTimeConfig.expressionLanguage.constraintExpressionFeatureLevel.isPresent()) {
                    configuration.constraintExpressionLanguageFeatureLevel(hibernateValidatorBuildTimeConfig.expressionLanguage.constraintExpressionFeatureLevel.get());
                }
                if ((configuredConstraintValidatorFactory = Arc.container().instance(ConstraintValidatorFactory.class, new Annotation[0])).isAvailable()) {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)configuredConstraintValidatorFactory.get());
                } else {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)new ArcConstraintValidatorFactoryImpl());
                }
                InstanceHandle configuredMessageInterpolator = Arc.container().instance(MessageInterpolator.class, new Annotation[0]);
                if (configuredMessageInterpolator.isAvailable()) {
                    configuration.messageInterpolator((MessageInterpolator)configuredMessageInterpolator.get());
                }
                if ((configuredTraversableResolver = Arc.container().instance(TraversableResolver.class, new Annotation[0])).isAvailable()) {
                    configuration.traversableResolver((TraversableResolver)configuredTraversableResolver.get());
                } else if (jpaInClasspath) {
                    configuration.traversableResolver((TraversableResolver)new JPATraversableResolver());
                } else {
                    configuration.traversableResolver((TraversableResolver)new TraverseAllTraversableResolver());
                }
                InstanceHandle configuredParameterNameProvider = Arc.container().instance(ParameterNameProvider.class, new Annotation[0]);
                if (configuredParameterNameProvider.isAvailable()) {
                    configuration.parameterNameProvider((ParameterNameProvider)configuredParameterNameProvider.get());
                }
                if ((configuredClockProvider = Arc.container().instance(ClockProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.clockProvider((ClockProvider)configuredClockProvider.get());
                }
                configuration.failFast(hibernateValidatorBuildTimeConfig.failFast);
                configuration.allowOverridingMethodAlterParameterConstraint(hibernateValidatorBuildTimeConfig.methodValidation.allowOverridingParameterConstraints);
                configuration.allowParallelMethodsDefineParameterConstraints(hibernateValidatorBuildTimeConfig.methodValidation.allowParameterConstraintsOnParallelMethods);
                configuration.allowMultipleCascadedValidationOnReturnValues(hibernateValidatorBuildTimeConfig.methodValidation.allowMultipleCascadedValidationOnReturnValues);
                InstanceHandle configuredScriptEvaluatorFactory = Arc.container().instance(ScriptEvaluatorFactory.class, new Annotation[0]);
                if (configuredScriptEvaluatorFactory.isAvailable()) {
                    configuration.scriptEvaluatorFactory((ScriptEvaluatorFactory)configuredScriptEvaluatorFactory.get());
                }
                if ((configuredGetterPropertySelectionStrategy = Arc.container().instance(GetterPropertySelectionStrategy.class, new Annotation[0])).isAvailable()) {
                    configuration.getterPropertySelectionStrategy((GetterPropertySelectionStrategy)configuredGetterPropertySelectionStrategy.get());
                }
                if ((configuredPropertyNodeNameProvider = Arc.container().instance(PropertyNodeNameProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.propertyNodeNameProvider((PropertyNodeNameProvider)configuredPropertyNodeNameProvider.get());
                }
                for (Object valueExtractor : Arc.container().beanManager().createInstance().select(TYPE_LITERAL_VALUE_EXTRACTOR_WITH_WILDCARD, new Annotation[0])) {
                    configuration.addValueExtractor((ValueExtractor)valueExtractor);
                }
                List validatorFactoryCustomizers = Arc.container().listAll(ValidatorFactoryCustomizer.class, new Annotation[0]);
                for (InstanceHandle validatorFactoryInstanceHandle : validatorFactoryCustomizers) {
                    if (!validatorFactoryInstanceHandle.isAvailable()) continue;
                    ValidatorFactoryCustomizer validatorFactoryCustomizer = (ValidatorFactoryCustomizer)validatorFactoryInstanceHandle.get();
                    validatorFactoryCustomizer.customize((BaseHibernateValidatorConfiguration<?>)configuration);
                }
                final ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
                ValidatorHolder.initialize((HibernateValidatorFactory)validatorFactory.unwrap(HibernateValidatorFactory.class));
                shutdownContext.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        validatorFactory.close();
                    }
                });
            }
        };
        return beanContainerListener;
    }

    public Supplier<ResteasyConfigSupport> resteasyConfigSupportSupplier(final boolean jsonDefault) {
        return new Supplier<ResteasyConfigSupport>(){

            @Override
            public ResteasyConfigSupport get() {
                return new ResteasyConfigSupport(jsonDefault);
            }
        };
    }
}

