/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.resolver.update.DefaultUpdateDiscovery;
import io.quarkus.bootstrap.resolver.update.DependenciesOrigin;
import io.quarkus.bootstrap.resolver.update.VersionUpdate;
import io.quarkus.bootstrap.resolver.update.VersionUpdateNumber;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.bootstrap.util.ZipUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.jboss.logging.Logger;

public class BootstrapAppModelFactory {
    private static final String QUARKUS = "quarkus";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String APP_MODEL_DAT = "app-model.dat";
    public static final String CREATOR_APP_GROUP_ID = "creator.app.groupId";
    public static final String CREATOR_APP_ARTIFACT_ID = "creator.app.artifactId";
    public static final String CREATOR_APP_CLASSIFIER = "creator.app.classifier";
    public static final String CREATOR_APP_TYPE = "creator.app.type";
    public static final String CREATOR_APP_VERSION = "creator.app.version";
    private static final int CP_CACHE_FORMAT_ID = 2;
    private static final Logger log = Logger.getLogger(BootstrapAppModelFactory.class);
    private AppArtifact managingProject;
    private Path appClasses;
    private List<Path> appCp = new ArrayList<Path>(0);
    private Boolean localProjectsDiscovery;
    private Boolean offline;
    private boolean enableClasspathCache;
    private boolean test;
    private boolean devMode;
    private AppModelResolver bootstrapAppModelResolver;
    private VersionUpdateNumber versionUpdateNumber;
    private VersionUpdate versionUpdate;
    private DependenciesOrigin dependenciesOrigin;
    private AppArtifact appArtifact;
    private MavenArtifactResolver mavenArtifactResolver;
    private LocalProject appClassesWorkspace;
    private List<AppDependency> forcedDependencies = Collections.emptyList();

    public static BootstrapAppModelFactory newInstance() {
        return new BootstrapAppModelFactory();
    }

    private BootstrapAppModelFactory() {
    }

    public BootstrapAppModelFactory setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelFactory setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public BootstrapAppModelFactory setAppClasses(Path appClasses) {
        this.appClasses = appClasses;
        return this;
    }

    public BootstrapAppModelFactory addToClassPath(Path path) {
        this.appCp.add(path);
        return this;
    }

    public BootstrapAppModelFactory setLocalProjectsDiscovery(Boolean localProjectsDiscovery) {
        this.localProjectsDiscovery = localProjectsDiscovery;
        return this;
    }

    public BootstrapAppModelFactory setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public BootstrapAppModelFactory setEnableClasspathCache(boolean enable) {
        this.enableClasspathCache = enable;
        return this;
    }

    public BootstrapAppModelFactory setBootstrapAppModelResolver(AppModelResolver bootstrapAppModelResolver) {
        this.bootstrapAppModelResolver = bootstrapAppModelResolver;
        return this;
    }

    public BootstrapAppModelFactory setVersionUpdateNumber(VersionUpdateNumber versionUpdateNumber) {
        this.versionUpdateNumber = versionUpdateNumber;
        return this;
    }

    public BootstrapAppModelFactory setVersionUpdate(VersionUpdate versionUpdate) {
        this.versionUpdate = versionUpdate;
        return this;
    }

    public BootstrapAppModelFactory setDependenciesOrigin(DependenciesOrigin dependenciesOrigin) {
        this.dependenciesOrigin = dependenciesOrigin;
        return this;
    }

    public BootstrapAppModelFactory setAppArtifact(AppArtifact appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public BootstrapAppModelFactory setForcedDependencies(List<AppDependency> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public AppModelResolver getAppModelResolver() {
        if (this.bootstrapAppModelResolver != null) {
            return this.bootstrapAppModelResolver;
        }
        if (this.appClasses == null) {
            throw new IllegalArgumentException("Application classes path has not been set");
        }
        try {
            if (!Files.isDirectory(this.appClasses, new LinkOption[0])) {
                MavenArtifactResolver mvn;
                if (this.mavenArtifactResolver == null) {
                    LocalProject localProject;
                    MavenArtifactResolver.Builder mvnBuilder = MavenArtifactResolver.builder();
                    if (this.offline != null) {
                        mvnBuilder.setOffline(this.offline);
                    }
                    LocalProject localProject2 = localProject = this.isWorkspaceDiscoveryEnabled() ? LocalProject.loadWorkspace(Paths.get("", new String[0]).normalize().toAbsolutePath(), false) : null;
                    if (localProject != null) {
                        mvnBuilder.setWorkspace(localProject.getWorkspace());
                        if (this.managingProject == null) {
                            this.managingProject = localProject.getAppArtifact();
                        }
                    }
                    mvn = mvnBuilder.build();
                } else {
                    mvn = this.mavenArtifactResolver;
                }
                this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
                return this.bootstrapAppModelResolver;
            }
            MavenArtifactResolver mvn = this.mavenArtifactResolver;
            if (mvn == null) {
                LocalProject localProject;
                MavenArtifactResolver.Builder builder = MavenArtifactResolver.builder();
                LocalProject localProject3 = localProject = this.isWorkspaceDiscoveryEnabled() ? this.loadAppClassesWorkspace() : null;
                if (localProject != null) {
                    builder.setWorkspace(localProject.getWorkspace());
                }
                if (this.offline != null) {
                    builder.setOffline(this.offline);
                }
                mvn = builder.build();
            }
            this.bootstrapAppModelResolver = new BootstrapAppModelResolver(mvn).setTest(this.test).setDevMode(this.devMode);
            return this.bootstrapAppModelResolver;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create resolver for " + this.appClasses, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CurationResult resolveAppModel() throws BootstrapException {
        String serializedModel;
        if ((this.test || this.devMode) && (serializedModel = System.getProperty("quarkus-internal.serialized-app-model.path")) != null) {
            Path p = Paths.get(serializedModel, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                try (InputStream existing = Files.newInputStream(Paths.get(serializedModel, new String[0]), new OpenOption[0]);){
                    AppModel appModel = (AppModel)new ObjectInputStream(existing).readObject();
                    CurationResult curationResult = new CurationResult(appModel);
                    return curationResult;
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error((Object)"Failed to load serialized app mode", e);
                    IoUtils.recursiveDelete(p);
                }
            } else {
                log.error("Failed to locate serialized application model at " + serializedModel);
            }
        }
        if (this.appClasses == null) {
            throw new IllegalArgumentException("Application classes path has not been set");
        }
        if (!Files.isDirectory(this.appClasses, new LinkOption[0])) {
            return this.createAppModelForJar(this.appClasses);
        }
        LocalProject localProject = null;
        AppArtifact appArtifact = this.appArtifact;
        if (appArtifact == null) {
            LocalProject localProject2 = localProject = this.enableClasspathCache ? this.loadAppClassesWorkspace() : LocalProject.load(this.appClasses, false);
            if (localProject == null) {
                log.warn("Unable to locate the maven project on the filesystem");
                throw new BootstrapException("Failed to determine the Maven artifact associated with the application");
            }
            appArtifact = localProject.getAppArtifact();
        }
        try {
            Path cachedCpPath = null;
            LocalWorkspace workspace = null;
            if (this.enableClasspathCache) {
                if (localProject == null) {
                    localProject = this.loadAppClassesWorkspace();
                }
                workspace = localProject.getWorkspace();
                cachedCpPath = this.resolveCachedCpPath(localProject);
                if (Files.exists(cachedCpPath, new LinkOption[0]) && workspace.getLastModified() < Files.getLastModifiedTime(cachedCpPath, new LinkOption[0]).toMillis()) {
                    try (DataInputStream reader = new DataInputStream(Files.newInputStream(cachedCpPath, new OpenOption[0]));){
                        if (reader.readInt() == 2) {
                            if (reader.readInt() == workspace.getId()) {
                                AppDependency i2;
                                ObjectInputStream in = new ObjectInputStream(reader);
                                AppModel appModel = (AppModel)in.readObject();
                                log.debugf("Loaded cached AppMode %s from %s", (Object)appModel, (Object)cachedCpPath);
                                for (AppDependency i2 : appModel.getFullDeploymentDeps()) {
                                    if (Files.exists(i2.getArtifact().getPath(), new LinkOption[0])) continue;
                                    throw new IOException("Cached artifact does not exist: " + i2.getArtifact().getPath());
                                }
                                Object object = appModel.getUserDependencies().iterator();
                                do {
                                    if (object.hasNext()) continue;
                                    object = new CurationResult(appModel);
                                    return object;
                                } while (Files.exists((i2 = object.next()).getArtifact().getPath(), new LinkOption[0]));
                                throw new IOException("Cached artifact does not exist: " + i2.getArtifact().getPath());
                            }
                            BootstrapAppModelFactory.debug("Cached deployment classpath has expired for %s", appArtifact);
                        } else {
                            BootstrapAppModelFactory.debug("Unsupported classpath cache format in %s for %s", cachedCpPath, appArtifact);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to read deployment classpath cache from " + cachedCpPath + " for " + appArtifact), e);
                    }
                }
            }
            AppModelResolver appModelResolver = this.getAppModelResolver();
            CurationResult curationResult = new CurationResult(appModelResolver.resolveManagedModel(appArtifact, this.forcedDependencies, this.managingProject));
            if (cachedCpPath == null) return curationResult;
            Files.createDirectories(cachedCpPath.getParent(), new FileAttribute[0]);
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(cachedCpPath, new OpenOption[0]));){
                out.writeInt(2);
                out.writeInt(workspace.getId());
                ObjectOutputStream obj = new ObjectOutputStream(out);
                obj.writeObject(curationResult.getAppModel());
                return curationResult;
            }
            catch (Exception e) {
                log.warn((Object)"Failed to write classpath cache", e);
            }
            return curationResult;
        }
        catch (Exception e) {
            throw new BootstrapException("Failed to create the application model for " + appArtifact, e);
        }
    }

    private boolean isWorkspaceDiscoveryEnabled() {
        return this.localProjectsDiscovery == null ? this.test || this.devMode : this.localProjectsDiscovery;
    }

    private LocalProject loadAppClassesWorkspace() throws BootstrapException {
        return this.appClassesWorkspace == null ? (this.appClassesWorkspace = LocalProject.loadWorkspace(this.appClasses, false)) : this.appClassesWorkspace;
    }

    private CurationResult createAppModelForJar(Path appArtifactPath) {
        List<AppDependency> appDeps;
        AppModel initialDepsList;
        AppArtifact appArtifact;
        AppModelResolver modelResolver;
        boolean loadedFromState;
        AppArtifact stateArtifact;
        block34: {
            log.debugf("provideOutcome depsOrigin=%s, versionUpdate=%s, versionUpdateNumber=%s", (Object)this.dependenciesOrigin, (Object)this.versionUpdate, (Object)this.versionUpdateNumber);
            stateArtifact = null;
            loadedFromState = false;
            modelResolver = this.getAppModelResolver();
            appArtifact = this.appArtifact;
            try {
                if (appArtifact == null) {
                    appArtifact = ModelUtils.resolveAppArtifact(appArtifactPath);
                }
                modelResolver.relink(appArtifact, appArtifactPath);
                if (this.dependenciesOrigin == DependenciesOrigin.LAST_UPDATE) {
                    log.info("Looking for the state of the last update");
                    Path statePath = null;
                    try {
                        stateArtifact = ModelUtils.getStateArtifact(appArtifact);
                        String latest = modelResolver.getLatestVersion(stateArtifact, null, false);
                        if (!stateArtifact.getVersion().equals(latest)) {
                            stateArtifact = new AppArtifact(stateArtifact.getGroupId(), stateArtifact.getArtifactId(), stateArtifact.getClassifier(), stateArtifact.getType(), latest);
                        }
                        statePath = modelResolver.resolve(stateArtifact);
                        log.info("- located the state at " + statePath);
                    }
                    catch (AppModelResolverException latest) {
                        // empty catch block
                    }
                    if (statePath != null) {
                        Model model;
                        try {
                            model = ModelUtils.readModel(statePath);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read application state " + statePath, e);
                        }
                        List<Dependency> modelStateDeps = model.getDependencies();
                        ArrayList<AppDependency> updatedDeps = new ArrayList<AppDependency>(modelStateDeps.size());
                        String groupIdProp = "${creator.app.groupId}";
                        for (Dependency modelDep : modelStateDeps) {
                            if (modelDep.getGroupId().equals("${creator.app.groupId}")) continue;
                            updatedDeps.add(new AppDependency(new AppArtifact(modelDep.getGroupId(), modelDep.getArtifactId(), modelDep.getClassifier(), modelDep.getType(), modelDep.getVersion()), modelDep.getScope(), modelDep.isOptional()));
                        }
                        initialDepsList = modelResolver.resolveModel(appArtifact, updatedDeps);
                        loadedFromState = true;
                        break block34;
                    }
                    initialDepsList = modelResolver.resolveModel(appArtifact);
                    break block34;
                }
                initialDepsList = modelResolver.resolveManagedModel(appArtifact, Collections.emptyList(), this.managingProject);
            }
            catch (AppModelResolverException | IOException e) {
                throw new RuntimeException("Failed to resolve initial application dependencies", e);
            }
        }
        if (this.versionUpdate == VersionUpdate.NONE) {
            return new CurationResult(initialDepsList, Collections.emptyList(), loadedFromState, appArtifact, stateArtifact);
        }
        log.info("Checking for available updates");
        try {
            appDeps = modelResolver.resolveUserDependencies(appArtifact, initialDepsList.getUserDependencies());
        }
        catch (AppModelResolverException e) {
            throw new RuntimeException("Failed to determine the list of dependencies to update", e);
        }
        Iterator<AppDependency> depsI = appDeps.iterator();
        while (depsI.hasNext()) {
            AppArtifact appDep = depsI.next().getArtifact();
            if (!appDep.getType().equals("jar")) {
                depsI.remove();
                continue;
            }
            Path path = appDep.getPath();
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (Files.exists(path.resolve("META-INF/quarkus-extension.properties"), new LinkOption[0])) continue;
                depsI.remove();
                continue;
            }
            try {
                FileSystem artifactFs = ZipUtils.newFileSystem(path);
                Object object = null;
                try {
                    if (Files.exists(artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]), new LinkOption[0])) continue;
                    depsI.remove();
                }
                catch (Throwable modelDep) {
                    object = modelDep;
                    throw modelDep;
                }
                finally {
                    if (artifactFs == null) continue;
                    if (object != null) {
                        try {
                            artifactFs.close();
                        }
                        catch (Throwable modelDep) {
                            ((Throwable)object).addSuppressed(modelDep);
                        }
                        continue;
                    }
                    artifactFs.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open " + path, e);
            }
        }
        DefaultUpdateDiscovery ud = new DefaultUpdateDiscovery(modelResolver, this.versionUpdateNumber);
        ArrayList<AppDependency> availableUpdates = null;
        int i = 0;
        while (i < appDeps.size()) {
            AppDependency dep = appDeps.get(i++);
            AppArtifact depArtifact = dep.getArtifact();
            String updatedVersion = this.versionUpdate == VersionUpdate.NEXT ? ud.getNextVersion(depArtifact) : ud.getLatestVersion(depArtifact);
            if (updatedVersion == null || depArtifact.getVersion().equals(updatedVersion)) continue;
            log.info(dep.getArtifact() + " -> " + updatedVersion);
            if (availableUpdates == null) {
                availableUpdates = new ArrayList<AppDependency>();
            }
            availableUpdates.add(new AppDependency(new AppArtifact(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getClassifier(), depArtifact.getType(), updatedVersion), dep.getScope()));
        }
        if (availableUpdates != null) {
            try {
                return new CurationResult(modelResolver.resolveManagedModel(appArtifact, availableUpdates, this.managingProject), availableUpdates, loadedFromState, appArtifact, stateArtifact);
            }
            catch (AppModelResolverException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("- no updates available");
        return new CurationResult(initialDepsList, Collections.emptyList(), loadedFromState, appArtifact, stateArtifact);
    }

    private Path resolveCachedCpPath(LocalProject project) {
        String filePrefix = this.test ? "test-" : (this.devMode ? "dev-" : null);
        return project.getOutputDir().resolve(QUARKUS).resolve(BOOTSTRAP).resolve(filePrefix == null ? APP_MODEL_DAT : filePrefix + APP_MODEL_DAT);
    }

    private static void debug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(String.format(msg, args));
        }
    }

    public BootstrapAppModelFactory setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
        this.mavenArtifactResolver = mavenArtifactResolver;
        return this;
    }

    public BootstrapAppModelFactory setManagingProject(AppArtifact managingProject) {
        this.managingProject = managingProject;
        return this;
    }
}

