/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.jboss.logging.Logger;

public class CurationResult {
    private static final Logger log = Logger.getLogger(CurationResult.class);
    private final AppModel appModel;
    private final List<AppDependency> updatedDependencies;
    private final boolean fromState;
    private final AppArtifact appArtifact;
    private final AppArtifact stateArtifact;
    private boolean persisted;

    public CurationResult(AppModel appModel) {
        this(appModel, Collections.emptyList(), false, null, null);
    }

    public CurationResult(AppModel appModel, List<AppDependency> updatedDependencies, boolean fromState, AppArtifact appArtifact, AppArtifact stateArtifact) {
        this.appModel = appModel;
        this.updatedDependencies = updatedDependencies;
        this.fromState = fromState;
        this.appArtifact = appArtifact;
        this.stateArtifact = stateArtifact;
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    public List<AppDependency> getUpdatedDependencies() {
        return this.updatedDependencies;
    }

    public boolean isFromState() {
        return this.fromState;
    }

    public AppArtifact getStateArtifact() {
        return this.stateArtifact;
    }

    public boolean hasUpdatedDeps() {
        return !this.updatedDependencies.isEmpty();
    }

    public void persist(AppModelResolver resolver) {
        Path stateDir;
        if (this.persisted || this.fromState && !this.hasUpdatedDeps()) {
            log.info("Skipping provisioning state persistence");
            return;
        }
        log.info("Persisting provisioning state");
        try {
            stateDir = Files.createTempDirectory("quarkus-state", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path statePom = stateDir.resolve("pom.xml");
        AppArtifact stateArtifact = this.stateArtifact == null ? ModelUtils.getStateArtifact(this.appArtifact) : new AppArtifact(this.stateArtifact.getGroupId(), this.stateArtifact.getArtifactId(), this.stateArtifact.getClassifier(), this.stateArtifact.getType(), String.valueOf(Long.valueOf(this.stateArtifact.getVersion()) + 1L));
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(stateArtifact.getGroupId());
        model.setArtifactId(stateArtifact.getArtifactId());
        model.setPackaging(stateArtifact.getType());
        model.setVersion(stateArtifact.getVersion());
        model.addProperty("creator.app.groupId", this.appArtifact.getGroupId());
        model.addProperty("creator.app.artifactId", this.appArtifact.getArtifactId());
        String classifier = this.appArtifact.getClassifier();
        if (!classifier.isEmpty()) {
            model.addProperty("creator.app.classifier", classifier);
        }
        model.addProperty("creator.app.type", this.appArtifact.getType());
        model.addProperty("creator.app.version", this.appArtifact.getVersion());
        Dependency appDep = new Dependency();
        appDep.setGroupId("${creator.app.groupId}");
        appDep.setArtifactId("${creator.app.artifactId}");
        if (!classifier.isEmpty()) {
            appDep.setClassifier("${creator.app.classifier}");
        }
        appDep.setType("${creator.app.type}");
        appDep.setVersion("${creator.app.version}");
        appDep.setScope("compile");
        model.addDependency(appDep);
        if (!this.updatedDependencies.isEmpty()) {
            for (AppDependency dep : this.updatedDependencies) {
                AppArtifact depArtifact = dep.getArtifact();
                String groupId = depArtifact.getGroupId();
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(groupId);
                exclusion.setArtifactId(depArtifact.getArtifactId());
                appDep.addExclusion(exclusion);
                Dependency updateDep = new Dependency();
                updateDep.setGroupId(groupId);
                updateDep.setArtifactId(depArtifact.getArtifactId());
                String updateClassifier = depArtifact.getClassifier();
                if (updateClassifier != null && !updateClassifier.isEmpty()) {
                    updateDep.setClassifier(updateClassifier);
                }
                updateDep.setType(depArtifact.getType());
                updateDep.setVersion(depArtifact.getVersion());
                updateDep.setScope(dep.getScope());
                model.addDependency(updateDep);
            }
        }
        try {
            ModelUtils.persistModel(statePom, model);
            ((BootstrapAppModelResolver)resolver).install(stateArtifact, statePom);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to persist application state artifact", e);
        }
        this.persisted = true;
        log.info("Persisted provisioning state as " + stateArtifact);
    }
}

