/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PathsCollection
implements Iterable<Path>,
Serializable {
    private List<Path> paths;

    public static PathsCollection from(Iterable<Path> paths) {
        ArrayList<Path> list = new ArrayList<Path>();
        paths.forEach(list::add);
        return new PathsCollection(list);
    }

    public static PathsCollection of(Path ... paths) {
        return new PathsCollection(Arrays.asList(paths));
    }

    public static Builder builder() {
        return new Builder();
    }

    private PathsCollection(List<Path> paths) {
        this.paths = Collections.unmodifiableList(paths);
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    public int size() {
        return this.paths.size();
    }

    public boolean isSinglePath() {
        return this.paths.size() == 1;
    }

    public Path getSinglePath() {
        if (this.paths.size() != 1) {
            throw new IllegalStateException("Paths collection expected to contain a single path but contains " + this.paths.size());
        }
        return this.paths.get(0);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.paths.iterator();
    }

    public boolean contains(Path path) {
        return this.paths.contains(path);
    }

    public PathsCollection add(Path ... paths) {
        ArrayList<Path> list = new ArrayList<Path>(this.paths.size() + paths.length);
        list.addAll(this.paths);
        for (int i = 0; i < paths.length; ++i) {
            list.add(paths[i]);
        }
        return new PathsCollection(list);
    }

    public PathsCollection addFirst(Path ... paths) {
        ArrayList<Path> list = new ArrayList<Path>(this.paths.size() + paths.length);
        for (int i = 0; i < paths.length; ++i) {
            list.add(paths[i]);
        }
        list.addAll(this.paths);
        return new PathsCollection(list);
    }

    public PathsCollection addAllFirst(Iterable<Path> i) {
        ArrayList<Path> list = new ArrayList<Path>();
        i.forEach(list::add);
        this.paths.forEach(list::add);
        return new PathsCollection(list);
    }

    public Path resolveExistingOrNull(String path) {
        for (Path p : this.paths) {
            Path resolved = p.resolve(path);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[paths: ");
        this.forEach(p -> buf.append(p).append(';'));
        return buf.append(']').toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.paths.size());
        for (Path p : this.paths) {
            out.writeUTF(p.toAbsolutePath().toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int pathsTotal = in.readInt();
        ArrayList<Path> paths = new ArrayList<Path>(pathsTotal);
        for (int i = 0; i < pathsTotal; ++i) {
            paths.add(Paths.get(in.readUTF(), new String[0]));
        }
        this.paths = Collections.unmodifiableList(paths);
    }

    public static class Builder {
        private List<Path> paths = new ArrayList<Path>();

        private Builder() {
        }

        public Builder add(Path path) {
            this.paths.add(path);
            return this;
        }

        public boolean contains(Path p) {
            return this.paths.contains(p);
        }

        public PathsCollection build() {
            return new PathsCollection(this.paths);
        }
    }
}

