/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.common.collect;

import io.quarkus.launcher.shaded.com.google.common.annotations.GwtCompatible;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("io.quarkus.launcher.shaded.null key in entry: null=" + value);
        }
        if (value == null) {
            throw new NullPointerException("io.quarkus.launcher.shaded.null value in entry: " + key + "io.quarkus.launcher.shaded.=null");
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + "io.quarkus.launcher.shaded. cannot be negative but was: " + value);
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + "io.quarkus.launcher.shaded. cannot be negative but was: " + value);
        }
        return value;
    }

    static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + "io.quarkus.launcher.shaded. must be positive but was: " + value);
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "io.quarkus.launcher.shaded.no calls to next() since the last call to remove()");
    }
}

