/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.common.eventbus;

import io.quarkus.launcher.shaded.com.google.common.annotations.Beta;
import io.quarkus.launcher.shaded.com.google.common.base.MoreObjects;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.eventbus.DeadEvent;
import io.quarkus.launcher.shaded.com.google.common.eventbus.Dispatcher;
import io.quarkus.launcher.shaded.com.google.common.eventbus.Subscriber;
import io.quarkus.launcher.shaded.com.google.common.eventbus.SubscriberExceptionContext;
import io.quarkus.launcher.shaded.com.google.common.eventbus.SubscriberExceptionHandler;
import io.quarkus.launcher.shaded.com.google.common.eventbus.SubscriberRegistry;
import io.quarkus.launcher.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("io.quarkus.launcher.shaded.default");
    }

    public EventBus(String identifier) {
        this(identifier, MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), LoggingHandler.INSTANCE);
    }

    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this("io.quarkus.launcher.shaded.default", MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), exceptionHandler);
    }

    EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        this.identifier = Preconditions.checkNotNull(identifier);
        this.executor = Preconditions.checkNotNull(executor);
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(context);
        try {
            this.exceptionHandler.handleException(e, context);
        }
        catch (Throwable e2) {
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "io.quarkus.launcher.shaded.Exception %s thrown while handling exception: %s", e2, e), e2);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.identifier).toString();
    }

    static final class LoggingHandler
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();

        LoggingHandler() {
        }

        @Override
        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            Logger logger = LoggingHandler.logger(context);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, LoggingHandler.message(context), exception);
            }
        }

        private static Logger logger(SubscriberExceptionContext context) {
            return Logger.getLogger(EventBus.class.getName() + "io.quarkus.launcher.shaded.." + context.getEventBus().identifier());
        }

        private static String message(SubscriberExceptionContext context) {
            Method method = context.getSubscriberMethod();
            return "io.quarkus.launcher.shaded.Exception thrown by subscriber method " + method.getName() + '(' + method.getParameterTypes()[0].getName() + ')' + "io.quarkus.launcher.shaded. on subscriber " + context.getSubscriber() + "io.quarkus.launcher.shaded. when dispatching event: " + context.getEvent();
        }
    }
}

