/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.common.math;

import io.quarkus.launcher.shaded.com.google.common.annotations.GwtCompatible;
import io.quarkus.launcher.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.quarkus.launcher.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.math.BigInteger;
import java.math.RoundingMode;

@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be > 0");
        }
        return x;
    }

    static long checkPositive(@Nullable String role, long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be > 0");
        }
        return x;
    }

    static BigInteger checkPositive(@Nullable String role, BigInteger x) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be > 0");
        }
        return x;
    }

    static int checkNonNegative(@Nullable String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be >= 0");
        }
        return x;
    }

    static long checkNonNegative(@Nullable String role, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be >= 0");
        }
        return x;
    }

    static BigInteger checkNonNegative(@Nullable String role, BigInteger x) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be >= 0");
        }
        return x;
    }

    static double checkNonNegative(@Nullable String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(role + "io.quarkus.launcher.shaded. (" + x + "io.quarkus.launcher.shaded.) must be >= 0");
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("io.quarkus.launcher.shaded.mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            throw new ArithmeticException("io.quarkus.launcher.shaded.rounded value is out of range for input " + input + "io.quarkus.launcher.shaded. and rounding mode " + (Object)((Object)mode));
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException("io.quarkus.launcher.shaded.overflow: " + methodName + "io.quarkus.launcher.shaded.(" + a + "io.quarkus.launcher.shaded., " + b + "io.quarkus.launcher.shaded.)");
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException("io.quarkus.launcher.shaded.overflow: " + methodName + "io.quarkus.launcher.shaded.(" + a + "io.quarkus.launcher.shaded., " + b + "io.quarkus.launcher.shaded.)");
        }
    }

    private MathPreconditions() {
    }
}

