/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.common.util.concurrent;

import io.quarkus.launcher.shaded.com.google.common.annotations.Beta;
import io.quarkus.launcher.shaded.com.google.common.annotations.GwtIncompatible;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.util.concurrent.ListenerCallQueue;
import io.quarkus.launcher.shaded.com.google.common.util.concurrent.Monitor;
import io.quarkus.launcher.shaded.com.google.common.util.concurrent.Service;
import io.quarkus.launcher.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.quarkus.launcher.shaded.com.google.errorprone.annotations.ForOverride;
import io.quarkus.launcher.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import io.quarkus.launcher.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
@GwtIncompatible
public abstract class AbstractService
implements Service {
    private static final ListenerCallQueue.Event<Service.Listener> STARTING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.starting();
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.starting()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> RUNNING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.running();
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.running()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_STARTING_EVENT = AbstractService.stoppingEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_RUNNING_EVENT = AbstractService.stoppingEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_NEW_EVENT = AbstractService.terminatedEvent(Service.State.NEW);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STARTING_EVENT = AbstractService.terminatedEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_RUNNING_EVENT = AbstractService.terminatedEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STOPPING_EVENT = AbstractService.terminatedEvent(Service.State.STOPPING);
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard isStartable = new IsStartableGuard();
    private final Monitor.Guard isStoppable = new IsStoppableGuard();
    private final Monitor.Guard hasReachedRunning = new HasReachedRunningGuard();
    private final Monitor.Guard isStopped = new IsStoppedGuard();
    private final ListenerCallQueue<Service.Listener> listeners = new ListenerCallQueue();
    private volatile StateSnapshot snapshot = new StateSnapshot(Service.State.NEW);

    private static ListenerCallQueue.Event<Service.Listener> terminatedEvent(final Service.State from) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.terminated(from);
            }

            public String toString() {
                return "io.quarkus.launcher.shaded.terminated({from = " + (Object)((Object)from) + "io.quarkus.launcher.shaded.})";
            }
        };
    }

    private static ListenerCallQueue.Event<Service.Listener> stoppingEvent(final Service.State from) {
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.stopping(from);
            }

            public String toString() {
                return "io.quarkus.launcher.shaded.stopping({from = " + (Object)((Object)from) + "io.quarkus.launcher.shaded.})";
            }
        };
    }

    protected AbstractService() {
    }

    @ForOverride
    protected abstract void doStart();

    @ForOverride
    protected abstract void doStop();

    @ForOverride
    protected void doCancelStart() {
    }

    @Override
    @CanIgnoreReturnValue
    public final Service startAsync() {
        if (this.monitor.enterIf(this.isStartable)) {
            try {
                this.snapshot = new StateSnapshot(Service.State.STARTING);
                this.enqueueStartingEvent();
                this.doStart();
            }
            catch (Throwable startupFailure) {
                this.notifyFailed(startupFailure);
            }
            finally {
                this.monitor.leave();
                this.dispatchListenerEvents();
            }
        } else {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Service " + this + "io.quarkus.launcher.shaded. has already been started");
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CanIgnoreReturnValue
    public final Service stopAsync() {
        if (!this.monitor.enterIf(this.isStoppable)) return this;
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: {
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(Service.State.NEW);
                    return this;
                }
                case STARTING: {
                    this.snapshot = new StateSnapshot(Service.State.STARTING, true, null);
                    this.enqueueStoppingEvent(Service.State.STARTING);
                    this.doCancelStart();
                    return this;
                }
                case RUNNING: {
                    this.snapshot = new StateSnapshot(Service.State.STOPPING);
                    this.enqueueStoppingEvent(Service.State.RUNNING);
                    this.doStop();
                    return this;
                }
                case STOPPING: 
                case TERMINATED: 
                case FAILED: {
                    throw new AssertionError((Object)("io.quarkus.launcher.shaded.isStoppable is incorrectly implemented, saw: " + (Object)((Object)previous)));
                }
            }
            return this;
        }
        catch (Throwable shutdownFailure) {
            this.notifyFailed(shutdownFailure);
            return this;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final void awaitRunning() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedRunning);
        try {
            this.checkCurrentState(Service.State.RUNNING);
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.hasReachedRunning, timeout, unit)) {
            try {
                this.checkCurrentState(Service.State.RUNNING);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            throw new TimeoutException("io.quarkus.launcher.shaded.Timed out waiting for " + this + "io.quarkus.launcher.shaded. to reach the RUNNING state.");
        }
    }

    @Override
    public final void awaitTerminated() {
        this.monitor.enterWhenUninterruptibly(this.isStopped);
        try {
            this.checkCurrentState(Service.State.TERMINATED);
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        if (this.monitor.enterWhenUninterruptibly(this.isStopped, timeout, unit)) {
            try {
                this.checkCurrentState(Service.State.TERMINATED);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            throw new TimeoutException("io.quarkus.launcher.shaded.Timed out waiting for " + this + "io.quarkus.launcher.shaded. to reach a terminal state. Current state: " + (Object)((Object)this.state()));
        }
    }

    @GuardedBy(value="io.quarkus.launcher.shaded.monitor")
    private void checkCurrentState(Service.State expected) {
        Service.State actual = this.state();
        if (actual != expected) {
            if (actual == Service.State.FAILED) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.Expected the service " + this + "io.quarkus.launcher.shaded. to be " + (Object)((Object)expected) + "io.quarkus.launcher.shaded., but the service has FAILED", this.failureCause());
            }
            throw new IllegalStateException("io.quarkus.launcher.shaded.Expected the service " + this + "io.quarkus.launcher.shaded. to be " + (Object)((Object)expected) + "io.quarkus.launcher.shaded., but was " + (Object)((Object)actual));
        }
    }

    protected final void notifyStarted() {
        this.monitor.enter();
        try {
            if (this.snapshot.state != Service.State.STARTING) {
                IllegalStateException failure = new IllegalStateException("io.quarkus.launcher.shaded.Cannot notifyStarted() when the service is " + (Object)((Object)this.snapshot.state));
                this.notifyFailed(failure);
                throw failure;
            }
            if (this.snapshot.shutdownWhenStartupFinishes) {
                this.snapshot = new StateSnapshot(Service.State.STOPPING);
                this.doStop();
            } else {
                this.snapshot = new StateSnapshot(Service.State.RUNNING);
                this.enqueueRunningEvent();
            }
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void notifyStopped() {
        this.monitor.enter();
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: 
                case FAILED: {
                    throw new IllegalStateException("io.quarkus.launcher.shaded.Cannot notifyStopped() when the service is " + (Object)((Object)previous));
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(previous);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void notifyFailed(Throwable cause) {
        Preconditions.checkNotNull(cause);
        this.monitor.enter();
        try {
            Service.State previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: {
                    throw new IllegalStateException("io.quarkus.launcher.shaded.Failed while in state:" + (Object)((Object)previous), cause);
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    this.snapshot = new StateSnapshot(Service.State.FAILED, false, cause);
                    this.enqueueFailedEvent(previous, cause);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state() == Service.State.RUNNING;
    }

    @Override
    public final Service.State state() {
        return this.snapshot.externalState();
    }

    @Override
    public final Throwable failureCause() {
        return this.snapshot.failureCause();
    }

    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        this.listeners.addListener(listener, executor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "io.quarkus.launcher.shaded. [" + (Object)((Object)this.state()) + "io.quarkus.launcher.shaded.]";
    }

    private void dispatchListenerEvents() {
        if (!this.monitor.isOccupiedByCurrentThread()) {
            this.listeners.dispatch();
        }
    }

    private void enqueueStartingEvent() {
        this.listeners.enqueue(STARTING_EVENT);
    }

    private void enqueueRunningEvent() {
        this.listeners.enqueue(RUNNING_EVENT);
    }

    private void enqueueStoppingEvent(Service.State from) {
        if (from == Service.State.STARTING) {
            this.listeners.enqueue(STOPPING_FROM_STARTING_EVENT);
        } else if (from == Service.State.RUNNING) {
            this.listeners.enqueue(STOPPING_FROM_RUNNING_EVENT);
        } else {
            throw new AssertionError();
        }
    }

    private void enqueueTerminatedEvent(Service.State from) {
        switch (from) {
            case NEW: {
                this.listeners.enqueue(TERMINATED_FROM_NEW_EVENT);
                break;
            }
            case STARTING: {
                this.listeners.enqueue(TERMINATED_FROM_STARTING_EVENT);
                break;
            }
            case RUNNING: {
                this.listeners.enqueue(TERMINATED_FROM_RUNNING_EVENT);
                break;
            }
            case STOPPING: {
                this.listeners.enqueue(TERMINATED_FROM_STOPPING_EVENT);
                break;
            }
            case TERMINATED: 
            case FAILED: {
                throw new AssertionError();
            }
        }
    }

    private void enqueueFailedEvent(final Service.State from, final Throwable cause) {
        this.listeners.enqueue(new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.failed(from, cause);
            }

            public String toString() {
                return "io.quarkus.launcher.shaded.failed({from = " + (Object)((Object)from) + "io.quarkus.launcher.shaded., cause = " + cause + "io.quarkus.launcher.shaded.})";
            }
        });
    }

    private static final class StateSnapshot {
        final Service.State state;
        final boolean shutdownWhenStartupFinishes;
        final @Nullable Throwable failure;

        StateSnapshot(Service.State internalState) {
            this(internalState, false, null);
        }

        StateSnapshot(Service.State internalState, boolean shutdownWhenStartupFinishes, @Nullable Throwable failure) {
            Preconditions.checkArgument(!shutdownWhenStartupFinishes || internalState == Service.State.STARTING, "io.quarkus.launcher.shaded.shutdownWhenStartupFinishes can only be set if state is STARTING. Got %s instead.", (Object)internalState);
            Preconditions.checkArgument(!(failure != null ^ internalState == Service.State.FAILED), "io.quarkus.launcher.shaded.A failure cause should be set if and only if the state is failed.  Got %s and %s instead.", (Object)internalState, (Object)failure);
            this.state = internalState;
            this.shutdownWhenStartupFinishes = shutdownWhenStartupFinishes;
            this.failure = failure;
        }

        Service.State externalState() {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                return Service.State.STOPPING;
            }
            return this.state;
        }

        Throwable failureCause() {
            Preconditions.checkState(this.state == Service.State.FAILED, "io.quarkus.launcher.shaded.failureCause() is only valid if the service has failed, service is %s", (Object)this.state);
            return this.failure;
        }
    }

    private final class IsStoppedGuard
    extends Monitor.Guard {
        IsStoppedGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().isTerminal();
        }
    }

    private final class HasReachedRunningGuard
    extends Monitor.Guard {
        HasReachedRunningGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) >= 0;
        }
    }

    private final class IsStoppableGuard
    extends Monitor.Guard {
        IsStoppableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) <= 0;
        }
    }

    private final class IsStartableGuard
    extends Monitor.Guard {
        IsStartableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public boolean isSatisfied() {
            return AbstractService.this.state() == Service.State.NEW;
        }
    }
}

