/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.common.xml;

import io.quarkus.launcher.shaded.com.google.common.annotations.Beta;
import io.quarkus.launcher.shaded.com.google.common.annotations.GwtCompatible;
import io.quarkus.launcher.shaded.com.google.common.escape.Escaper;
import io.quarkus.launcher.shaded.com.google.common.escape.Escapers;

@Beta
@GwtCompatible
public class XmlEscapers {
    private static final char MIN_ASCII_CONTROL_CHAR = '\u0000';
    private static final char MAX_ASCII_CONTROL_CHAR = '\u001f';
    private static final Escaper XML_ESCAPER;
    private static final Escaper XML_CONTENT_ESCAPER;
    private static final Escaper XML_ATTRIBUTE_ESCAPER;

    private XmlEscapers() {
    }

    public static Escaper xmlContentEscaper() {
        return XML_CONTENT_ESCAPER;
    }

    public static Escaper xmlAttributeEscaper() {
        return XML_ATTRIBUTE_ESCAPER;
    }

    static {
        Escapers.Builder builder = Escapers.builder();
        builder.setSafeRange('\u0000', '\ufffd');
        builder.setUnsafeReplacement("io.quarkus.launcher.shaded.\ufffd");
        for (char c = '\u0000'; c <= '\u001f'; c = (char)((char)(c + 1))) {
            if (c == 9 || c == 10 || c == 13) continue;
            builder.addEscape(c, "io.quarkus.launcher.shaded.\ufffd");
        }
        builder.addEscape('&', "io.quarkus.launcher.shaded.&amp;");
        builder.addEscape('<', "io.quarkus.launcher.shaded.&lt;");
        builder.addEscape('>', "io.quarkus.launcher.shaded.&gt;");
        XML_CONTENT_ESCAPER = builder.build();
        builder.addEscape('\'', "io.quarkus.launcher.shaded.&apos;");
        builder.addEscape('\"', "io.quarkus.launcher.shaded.&quot;");
        XML_ESCAPER = builder.build();
        builder.addEscape('\t', "io.quarkus.launcher.shaded.&#x9;");
        builder.addEscape('\n', "io.quarkus.launcher.shaded.&#xA;");
        builder.addEscape('\r', "io.quarkus.launcher.shaded.&#xD;");
        XML_ATTRIBUTE_ESCAPER = builder.build();
    }
}

