/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.ConfigurationException;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.binder.AnnotatedBindingBuilder;
import io.quarkus.launcher.shaded.com.google.inject.binder.ScopedBindingBuilder;
import io.quarkus.launcher.shaded.com.google.inject.internal.AbstractBindingBuilder;
import io.quarkus.launcher.shaded.com.google.inject.internal.BindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstructorBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InstanceBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.LinkedBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.LinkedProviderBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProviderInstanceBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.Scoping;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionPoint;
import io.quarkus.launcher.shaded.com.google.inject.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> elements, Object source, Key<T> key) {
        super(binder, elements, source, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> implementation) {
        return this.to((Key)Key.get(implementation));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> linkedKey) {
        Preconditions.checkNotNull(linkedKey, "io.quarkus.launcher.shaded.linkedKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), linkedKey));
        return this;
    }

    @Override
    public void toInstance(T instance) {
        Set injectionPoints;
        this.checkNotTargetted();
        if (instance != null) {
            try {
                injectionPoints = InjectionPoint.forInstanceMethodsAndFields(instance.getClass());
            }
            catch (ConfigurationException e) {
                this.copyErrorsToBinder(e);
                injectionPoints = (Set)e.getPartialValue();
            }
        } else {
            this.binder.addError("io.quarkus.launcher.shaded.Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            injectionPoints = ImmutableSet.of();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new InstanceBindingImpl(base.getSource(), base.getKey(), Scoping.EAGER_SINGLETON, injectionPoints, instance));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        return this.toProvider((io.quarkus.launcher.shaded.javax.inject.Provider)provider);
    }

    @Override
    public BindingBuilder<T> toProvider(io.quarkus.launcher.shaded.javax.inject.Provider<? extends T> provider) {
        Set injectionPoints;
        Preconditions.checkNotNull(provider, "io.quarkus.launcher.shaded.provider");
        this.checkNotTargetted();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        BindingImpl base = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(base.getSource(), base.getKey(), base.getScoping(), injectionPoints, provider));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends io.quarkus.launcher.shaded.javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(TypeLiteral<? extends io.quarkus.launcher.shaded.javax.inject.Provider<? extends T>> providerType) {
        return this.toProvider((Key)Key.get(providerType));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends io.quarkus.launcher.shaded.javax.inject.Provider<? extends T>> providerKey) {
        Preconditions.checkNotNull(providerKey, "io.quarkus.launcher.shaded.providerKey");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(base.getSource(), base.getKey(), base.getScoping(), providerKey));
        return this;
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor) {
        return this.toConstructor(constructor, TypeLiteral.get(constructor.getDeclaringClass()));
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor, TypeLiteral<? extends S> type) {
        Set injectionPoints;
        Preconditions.checkNotNull(constructor, "io.quarkus.launcher.shaded.constructor");
        Preconditions.checkNotNull(type, "io.quarkus.launcher.shaded.type");
        this.checkNotTargetted();
        BindingImpl base = this.getBinding();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
            injectionPoints = (Set)e.getPartialValue();
        }
        try {
            InjectionPoint constructorPoint = InjectionPoint.forConstructor(constructor, type);
            this.setBinding(new ConstructorBindingImpl(base.getKey(), base.getSource(), base.getScoping(), constructorPoint, injectionPoints));
        }
        catch (ConfigurationException e) {
            this.copyErrorsToBinder(e);
        }
        return this;
    }

    public String toString() {
        return "io.quarkus.launcher.shaded.BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + "io.quarkus.launcher.shaded.>";
    }

    private void copyErrorsToBinder(ConfigurationException e) {
        for (Message message : e.getErrorMessages()) {
            this.binder.addError(message);
        }
    }
}

