/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.MoreObjects;
import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.Scoping;
import io.quarkus.launcher.shaded.com.google.inject.spi.BindingScopingVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.InstanceBinding;

public abstract class BindingImpl<T>
implements Binding<T> {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Object source;
    private final Scoping scoping;
    private final InternalFactory<? extends T> internalFactory;
    private volatile Provider<T> provider;

    public BindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping) {
        this.injector = injector;
        this.key = key;
        this.source = source;
        this.internalFactory = internalFactory;
        this.scoping = scoping;
    }

    protected BindingImpl(Object source, Key<T> key, Scoping scoping) {
        this.internalFactory = null;
        this.injector = null;
        this.source = source;
        this.key = key;
        this.scoping = scoping;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Provider<T> getProvider() {
        if (this.provider == null) {
            if (this.injector == null) {
                throw new UnsupportedOperationException("io.quarkus.launcher.shaded.getProvider() not supported for module bindings");
            }
            this.provider = this.injector.getProvider(this.key);
        }
        return this.provider;
    }

    public InternalFactory<? extends T> getInternalFactory() {
        return this.internalFactory;
    }

    public Scoping getScoping() {
        return this.scoping;
    }

    public boolean isConstant() {
        return this instanceof InstanceBinding;
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor) {
        return this.scoping.acceptVisitor(visitor);
    }

    protected BindingImpl<T> withScoping(Scoping scoping) {
        throw new AssertionError();
    }

    protected BindingImpl<T> withKey(Key<T> key) {
        throw new AssertionError();
    }

    public String toString() {
        return MoreObjects.toStringHelper(Binding.class).add("io.quarkus.launcher.shaded.key", this.key).add("io.quarkus.launcher.shaded.scope", this.scoping).add("io.quarkus.launcher.shaded.source", this.source).toString();
    }

    public InjectorImpl getInjector() {
        return this.injector;
    }
}

