/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstructionContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.CreationListener;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.ErrorsException;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProviderInternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.javax.inject.Provider;

final class BoundProviderFactory<T>
extends ProviderInternalFactory<T>
implements CreationListener {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injector, Key<? extends Provider<? extends T>> providerKey, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = provisionCallback;
        this.injector = injector;
        this.providerKey = providerKey;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        context.pushState(this.providerKey, this.source);
        try {
            Provider<? extends T> provider = this.providerFactory.get(context, dependency, true);
            T t = this.circularGet(provider, context, dependency, this.provisionCallback);
            return t;
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(this.providerKey);
        }
        finally {
            context.popState();
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            return super.provision(provider, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw InternalProvisionException.errorInProvider(userException);
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

