/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.MoreObjects;
import io.quarkus.launcher.shaded.com.google.common.base.Objects;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.ConfigurationException;
import io.quarkus.launcher.shaded.com.google.inject.Inject;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.internal.Annotations;
import io.quarkus.launcher.shaded.com.google.inject.internal.BindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstructionProxy;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstructorInjector;
import io.quarkus.launcher.shaded.com.google.inject.internal.DefaultConstructionProxyFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.DelayedInitialize;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.ErrorsException;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import io.quarkus.launcher.shaded.com.google.inject.internal.Scoping;
import io.quarkus.launcher.shaded.com.google.inject.internal.util.Classes;
import io.quarkus.launcher.shaded.com.google.inject.spi.BindingTargetVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ConstructorBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Set;

final class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T>,
DelayedInitialize {
    private final Factory<T> factory;
    private final InjectionPoint constructorInjectionPoint;

    private ConstructorBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> scopedFactory, Scoping scoping, Factory<T> factory, InjectionPoint constructorInjectionPoint) {
        super(injector, key, source, scopedFactory, scoping);
        this.factory = factory;
        this.constructorInjectionPoint = constructorInjectionPoint;
    }

    public ConstructorBindingImpl(Key<T> key, Object source, Scoping scoping, InjectionPoint constructorInjectionPoint, Set<InjectionPoint> injectionPoints) {
        super(source, key, scoping);
        this.factory = new Factory(false, key);
        ConstructionProxy constructionProxy = new DefaultConstructionProxyFactory(constructorInjectionPoint).create();
        this.constructorInjectionPoint = constructorInjectionPoint;
        ((Factory)this.factory).constructorInjector = new ConstructorInjector(injectionPoints, constructionProxy, null, null);
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injector, Key<T> key, InjectionPoint constructorInjector, Object source, Scoping scoping, Errors errors, boolean failIfNotLinked, boolean failIfNotExplicit) throws ErrorsException {
        Class<?> annotatedType;
        Class<? extends Annotation> scopeAnnotation;
        Class<Object> rawType;
        int numErrors = errors.size();
        Class<Object> clazz = rawType = constructorInjector == null ? key.getTypeLiteral().getRawType() : constructorInjector.getDeclaringType().getRawType();
        if (Modifier.isAbstract(rawType.getModifiers())) {
            errors.missingImplementationWithHint(key, injector);
        }
        if (Classes.isInnerClass(rawType)) {
            errors.cannotInjectInnerClass(rawType);
        }
        errors.throwIfNewErrors(numErrors);
        if (constructorInjector == null) {
            try {
                constructorInjector = InjectionPoint.forConstructorOf(key.getTypeLiteral());
                if (failIfNotExplicit && !ConstructorBindingImpl.hasAtInject((Constructor)constructorInjector.getMember())) {
                    errors.atInjectRequired(rawType);
                }
            }
            catch (ConfigurationException e) {
                throw errors.merge(e.getErrorMessages()).toException();
            }
        }
        if (!scoping.isExplicitlyScoped() && (scopeAnnotation = Annotations.findScopeAnnotation(errors, annotatedType = constructorInjector.getMember().getDeclaringClass())) != null) {
            scoping = Scoping.makeInjectable(Scoping.forAnnotation(scopeAnnotation), injector, errors.withSource(rawType));
        }
        errors.throwIfNewErrors(numErrors);
        Factory factoryFactory = new Factory(failIfNotLinked, key);
        InternalFactory<T> scopedFactory = Scoping.scope(key, injector, factoryFactory, source, scoping);
        return new ConstructorBindingImpl<T>(injector, key, source, scopedFactory, scoping, factoryFactory, constructorInjector);
    }

    private static boolean hasAtInject(Constructor cxtor) {
        return cxtor.isAnnotationPresent(Inject.class) || cxtor.isAnnotationPresent(io.quarkus.launcher.shaded.javax.inject.Inject.class);
    }

    @Override
    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        ((Factory)this.factory).constructorInjector = injector.constructors.get(this.constructorInjectionPoint, errors);
        ((Factory)this.factory).provisionCallback = injector.provisionListenerStore.get(this);
    }

    boolean isInitialized() {
        return ((Factory)this.factory).constructorInjector != null;
    }

    InjectionPoint getInternalConstructor() {
        if (((Factory)this.factory).constructorInjector != null) {
            return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
        }
        return this.constructorInjectionPoint;
    }

    Set<Dependency<?>> getInternalDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (((Factory)this.factory).constructorInjector == null) {
            builder.add(this.constructorInjectionPoint);
            try {
                builder.addAll(InjectionPoint.forInstanceMethodsAndFields(this.constructorInjectionPoint.getDeclaringType()));
            }
            catch (ConfigurationException configurationException) {}
        } else {
            ((ImmutableSet.Builder)builder.add(this.getConstructor())).addAll(this.getInjectableMembers());
        }
        return Dependency.forInjectionPoints((Set<InjectionPoint>)((Object)builder.build()));
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "io.quarkus.launcher.shaded.not initialized");
        return visitor.visit(this);
    }

    @Override
    public InjectionPoint getConstructor() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "io.quarkus.launcher.shaded.Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
    }

    @Override
    public Set<InjectionPoint> getInjectableMembers() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "io.quarkus.launcher.shaded.Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getInjectableMembers();
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Dependency.forInjectionPoints((Set<InjectionPoint>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().add(this.getConstructor())).addAll(this.getInjectableMembers())).build()));
    }

    @Override
    protected BindingImpl<T> withScoping(Scoping scoping) {
        return new ConstructorBindingImpl(null, this.getKey(), this.getSource(), this.factory, scoping, this.factory, this.constructorInjectionPoint);
    }

    @Override
    protected BindingImpl<T> withKey(Key<T> key) {
        return new ConstructorBindingImpl<T>(null, key, this.getSource(), this.factory, this.getScoping(), this.factory, this.constructorInjectionPoint);
    }

    @Override
    public void applyTo(Binder binder) {
        InjectionPoint constructor = this.getConstructor();
        this.getScoping().applyTo(binder.withSource(this.getSource()).bind(this.getKey()).toConstructor((Constructor)this.getConstructor().getMember(), constructor.getDeclaringType()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ConstructorBinding.class).add("io.quarkus.launcher.shaded.key", this.getKey()).add("io.quarkus.launcher.shaded.source", this.getSource()).add("io.quarkus.launcher.shaded.scope", this.getScoping()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstructorBindingImpl) {
            ConstructorBindingImpl o = (ConstructorBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.constructorInjectionPoint, o.constructorInjectionPoint);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey(), this.getScoping(), this.constructorInjectionPoint);
    }

    private static class Factory<T>
    implements InternalFactory<T> {
        private final boolean failIfNotLinked;
        private final Key<?> key;
        private ConstructorInjector<T> constructorInjector;
        private ProvisionListenerStackCallback<T> provisionCallback;

        Factory(boolean failIfNotLinked, Key<?> key) {
            this.failIfNotLinked = failIfNotLinked;
            this.key = key;
        }

        @Override
        public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
            ConstructorInjector<T> localInjector = this.constructorInjector;
            if (localInjector == null) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.Constructor not ready");
            }
            if (!linked && this.failIfNotLinked) {
                throw InternalProvisionException.jitDisabled(this.key);
            }
            return (T)localInjector.construct(context, dependency, this.provisionCallback);
        }
    }
}

