/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.MoreObjects;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.internal.CreationListener;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.ErrorsException;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;

final class FactoryProxy<T>
implements InternalFactory<T>,
CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injector, Key<T> key, Key<? extends T> targetKey, Object source) {
        this.injector = injector;
        this.key = key;
        this.targetKey = targetKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        Key<? extends T> localTargetKey = this.targetKey;
        context.pushState(localTargetKey, this.source);
        try {
            T t = this.targetFactory.get(context, dependency, true);
            return t;
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(localTargetKey);
        }
        finally {
            context.popState();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(FactoryProxy.class).add("io.quarkus.launcher.shaded.key", this.key).add("io.quarkus.launcher.shaded.provider", this.targetFactory).toString();
    }
}

