/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.common.collect.Lists;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.Scopes;
import io.quarkus.launcher.shaded.com.google.inject.Singleton;
import io.quarkus.launcher.shaded.com.google.inject.Stage;
import io.quarkus.launcher.shaded.com.google.inject.internal.BindingProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstantFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.InheritingState;
import io.quarkus.launcher.shaded.com.google.inject.internal.Initializables;
import io.quarkus.launcher.shaded.com.google.inject.internal.Initializer;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorOptionsProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.InstanceBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.ListenerBindingProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.MembersInjectorStore;
import io.quarkus.launcher.shaded.com.google.inject.internal.MessageProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.ModuleAnnotatedMethodScannerProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.PrivateElementProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.PrivateElementsImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProcessedBindingData;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProviderInstanceBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProvisionListenerCallbackStore;
import io.quarkus.launcher.shaded.com.google.inject.internal.ScopeBindingProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.Scoping;
import io.quarkus.launcher.shaded.com.google.inject.internal.State;
import io.quarkus.launcher.shaded.com.google.inject.internal.TypeConverterBindingProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.UntargettedBindingProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.util.SourceProvider;
import io.quarkus.launcher.shaded.com.google.inject.internal.util.Stopwatch;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.Elements;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionPoint;
import io.quarkus.launcher.shaded.com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.PrivateElements;
import io.quarkus.launcher.shaded.com.google.inject.spi.ProvisionListenerBinding;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeListenerBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class InjectorShell {
    private final List<Element> elements;
    private final InjectorImpl injector;

    private InjectorShell(List<Element> elements, InjectorImpl injector) {
        this.elements = elements;
        this.injector = injector;
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    List<Element> getElements() {
        return this.elements;
    }

    private static void bindInjector(InjectorImpl injector) {
        Key<Injector> key = Key.get(Injector.class);
        InjectorFactory injectorFactory = new InjectorFactory(injector);
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Injector>(injector, key, SourceProvider.UNKNOWN_SOURCE, injectorFactory, Scoping.UNSCOPED, injectorFactory, ImmutableSet.of()));
    }

    private static void bindLogger(InjectorImpl injector) {
        Key<Logger> key = Key.get(Logger.class);
        LoggerFactory loggerFactory = new LoggerFactory();
        injector.state.putBinding(key, new ProviderInstanceBindingImpl<Logger>(injector, key, SourceProvider.UNKNOWN_SOURCE, loggerFactory, Scoping.UNSCOPED, loggerFactory, ImmutableSet.of()));
    }

    private static void bindStage(InjectorImpl injector, Stage stage) {
        Key<Stage> key = Key.get(Stage.class);
        InstanceBindingImpl<Stage> stageBinding = new InstanceBindingImpl<Stage>(injector, key, SourceProvider.UNKNOWN_SOURCE, new ConstantFactory<Stage>(Initializables.of(stage)), ImmutableSet.of(), stage);
        injector.state.putBinding(key, stageBinding);
    }

    private static class InheritedScannersModule
    implements Module {
        private final State state;

        InheritedScannersModule(State state) {
            this.state = state;
        }

        @Override
        public void configure(Binder binder) {
            for (ModuleAnnotatedMethodScannerBinding binding : this.state.getScannerBindings()) {
                binding.applyTo(binder);
            }
        }
    }

    private static class RootModule
    implements Module {
        private RootModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.withSource(SourceProvider.UNKNOWN_SOURCE);
            binder.bindScope(Singleton.class, Scopes.SINGLETON);
            binder.bindScope(io.quarkus.launcher.shaded.javax.inject.Singleton.class, Scopes.SINGLETON);
        }
    }

    private static class LoggerFactory
    implements InternalFactory<Logger>,
    Provider<Logger> {
        private LoggerFactory() {
        }

        @Override
        public Logger get(InternalContext context, Dependency<?> dependency, boolean linked) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            return injectionPoint == null ? Logger.getAnonymousLogger() : Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
        }

        @Override
        public Logger get() {
            return Logger.getAnonymousLogger();
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.Provider<Logger>";
        }
    }

    private static class InjectorFactory
    implements InternalFactory<Injector>,
    Provider<Injector> {
        private final Injector injector;

        private InjectorFactory(Injector injector) {
            this.injector = injector;
        }

        @Override
        public Injector get(InternalContext context, Dependency<?> dependency, boolean linked) {
            return this.injector;
        }

        @Override
        public Injector get() {
            return this.injector;
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.Provider<Injector>";
        }
    }

    static class Builder {
        private final List<Element> elements = Lists.newArrayList();
        private final List<Module> modules = Lists.newArrayList();
        private State state;
        private InjectorImpl parent;
        private InjectorImpl.InjectorOptions options;
        private Stage stage;
        private PrivateElementsImpl privateElements;

        Builder() {
        }

        Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        Builder parent(InjectorImpl parent) {
            this.parent = parent;
            this.state = new InheritingState(parent.state);
            this.options = parent.options;
            this.stage = this.options.stage;
            return this;
        }

        Builder privateElements(PrivateElements privateElements) {
            this.privateElements = (PrivateElementsImpl)privateElements;
            this.elements.addAll(privateElements.getElements());
            return this;
        }

        void addModules(Iterable<? extends Module> modules) {
            for (Module module : modules) {
                this.modules.add(module);
            }
        }

        Stage getStage() {
            return this.options.stage;
        }

        Object lock() {
            return this.getState().lock();
        }

        List<InjectorShell> build(Initializer initializer, ProcessedBindingData bindingData, Stopwatch stopwatch, Errors errors) {
            Preconditions.checkState(this.stage != null, "io.quarkus.launcher.shaded.Stage not initialized");
            Preconditions.checkState(this.privateElements == null || this.parent != null, "io.quarkus.launcher.shaded.PrivateElements with no parent");
            Preconditions.checkState(this.state != null, "io.quarkus.launcher.shaded.no state. Did you remember to lock() ?");
            if (this.parent == null) {
                this.modules.add(0, new RootModule());
            } else {
                this.modules.add(0, new InheritedScannersModule(this.parent.state));
            }
            this.elements.addAll(Elements.getElements(this.stage, this.modules));
            InjectorOptionsProcessor optionsProcessor = new InjectorOptionsProcessor(errors);
            optionsProcessor.process(null, this.elements);
            this.options = optionsProcessor.getOptions(this.stage, this.options);
            InjectorImpl injector = new InjectorImpl(this.parent, this.state, this.options);
            if (this.privateElements != null) {
                this.privateElements.initInjector(injector);
            }
            if (this.parent == null) {
                TypeConverterBindingProcessor.prepareBuiltInConverters(injector);
            }
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Module execution");
            new MessageProcessor(errors).process(injector, this.elements);
            new ListenerBindingProcessor(errors).process(injector, this.elements);
            List<TypeListenerBinding> typeListenerBindings = injector.state.getTypeListenerBindings();
            injector.membersInjectorStore = new MembersInjectorStore(injector, typeListenerBindings);
            List<ProvisionListenerBinding> provisionListenerBindings = injector.state.getProvisionListenerBindings();
            injector.provisionListenerStore = new ProvisionListenerCallbackStore(provisionListenerBindings);
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.TypeListeners & ProvisionListener creation");
            new ScopeBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Scopes creation");
            new TypeConverterBindingProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Converters creation");
            InjectorShell.bindStage(injector, this.stage);
            InjectorShell.bindInjector(injector);
            InjectorShell.bindLogger(injector);
            new BindingProcessor(errors, initializer, bindingData).process(injector, this.elements);
            new UntargettedBindingProcessor(errors, bindingData).process(injector, this.elements);
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Binding creation");
            new ModuleAnnotatedMethodScannerProcessor(errors).process(injector, this.elements);
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Module annotated method scanners creation");
            ArrayList<InjectorShell> injectorShells = Lists.newArrayList();
            injectorShells.add(new InjectorShell(this.elements, injector));
            PrivateElementProcessor processor = new PrivateElementProcessor(errors);
            processor.process(injector, this.elements);
            for (Builder builder : processor.getInjectorShellBuilders()) {
                injectorShells.addAll(builder.build(initializer, bindingData, stopwatch, errors));
            }
            stopwatch.resetAndLog("io.quarkus.launcher.shaded.Private environment creation");
            return injectorShells;
        }

        private State getState() {
            if (this.state == null) {
                this.state = new InheritingState(State.NONE);
            }
            return this.state;
        }
    }
}

