/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.inject.internal.ConstructionContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.Initializable;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProviderInternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProvisionListenerStackCallback;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.javax.inject.Provider;

final class InternalFactoryToInitializableAdapter<T>
extends ProviderInternalFactory<T> {
    private final ProvisionListenerStackCallback<T> provisionCallback;
    private final Initializable<? extends Provider<? extends T>> initializable;

    public InternalFactoryToInitializableAdapter(Initializable<? extends Provider<? extends T>> initializable, Object source, ProvisionListenerStackCallback<T> provisionCallback) {
        super(source);
        this.provisionCallback = provisionCallback;
        this.initializable = Preconditions.checkNotNull(initializable, "io.quarkus.launcher.shaded.provider");
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        return this.circularGet(this.initializable.get(), context, dependency, this.provisionCallback);
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            return super.provision(provider, dependency, constructionContext);
        }
        catch (RuntimeException userException) {
            throw InternalProvisionException.errorInProvider(userException).addSource(this.source);
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

