/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.inject.Binding;
import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.MembersInjector;
import io.quarkus.launcher.shaded.com.google.inject.Module;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.Scope;
import io.quarkus.launcher.shaded.com.google.inject.Stage;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.internal.BindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.DeferredLookups;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.Initializer;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectionRequestProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorShell;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalContext;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalProvisionException;
import io.quarkus.launcher.shaded.com.google.inject.internal.LinkedBindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.LookupProcessor;
import io.quarkus.launcher.shaded.com.google.inject.internal.ProcessedBindingData;
import io.quarkus.launcher.shaded.com.google.inject.internal.util.Stopwatch;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeConverterBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class InternalInjectorCreator {
    private final Stopwatch stopwatch = new Stopwatch();
    private final Errors errors = new Errors();
    private final Initializer initializer = new Initializer();
    private final ProcessedBindingData bindingData;
    private final InjectionRequestProcessor injectionRequestProcessor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    public InternalInjectorCreator() {
        this.injectionRequestProcessor = new InjectionRequestProcessor(this.errors, this.initializer);
        this.bindingData = new ProcessedBindingData();
    }

    public InternalInjectorCreator stage(Stage stage) {
        this.shellBuilder.stage(stage);
        return this;
    }

    public InternalInjectorCreator parentInjector(InjectorImpl parent) {
        this.shellBuilder.parent(parent);
        return this;
    }

    public InternalInjectorCreator addModules(Iterable<? extends Module> modules) {
        this.shellBuilder.addModules(modules);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector build() {
        if (this.shellBuilder == null) {
            throw new AssertionError((Object)"io.quarkus.launcher.shaded.Already built, builders are not reusable.");
        }
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.initializer, this.bindingData, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Injector construction");
            this.initializeStatically();
        }
        this.injectDynamically();
        if (this.shellBuilder.getStage() == Stage.TOOL) {
            return new ToolStageInjector(this.primaryInjector());
        }
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.bindingData.initializeBindings();
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Binding initialization");
        for (InjectorShell shell : this.shells) {
            shell.getInjector().index();
        }
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Binding indexing");
        this.injectionRequestProcessor.process(this.shells);
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Collecting injection requests");
        this.bindingData.runCreationListeners(this.errors);
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Binding validation");
        this.injectionRequestProcessor.validate();
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Static validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell shell : this.shells) {
            ((DeferredLookups)shell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Provider verification");
        this.bindingData.initializeDelayedBindings();
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Delayed Binding initialization");
        for (InjectorShell shell : this.shells) {
            if (!shell.getElements().isEmpty()) {
                throw new AssertionError((Object)("io.quarkus.launcher.shaded.Failed to execute " + shell.getElements()));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.injectionRequestProcessor.injectMembers();
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Static member injection");
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        if (this.shellBuilder.getStage() != Stage.TOOL) {
            for (InjectorShell shell : this.shells) {
                this.loadEagerSingletons(shell.getInjector(), this.shellBuilder.getStage(), this.errors);
            }
            this.stopwatch.resetAndLog("io.quarkus.launcher.shaded.Preloading singletons");
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadEagerSingletons(InjectorImpl injector, Stage stage, Errors errors) {
        ArrayList candidateBindings = new ArrayList();
        Collection<Binding<?>> bindingsAtThisLevel = injector.state.getExplicitBindingsThisLevel().values();
        candidateBindings.addAll(bindingsAtThisLevel);
        Object object = injector.state.lock();
        synchronized (object) {
            candidateBindings.addAll(injector.jitBindings.values());
        }
        try (InternalContext context = injector.enterContext();){
            for (BindingImpl bindingImpl : candidateBindings) {
                if (!this.isEagerSingleton(injector, bindingImpl, stage)) continue;
                Dependency dependency = Dependency.get(bindingImpl.getKey());
                Dependency<?> previous = context.pushDependency(dependency, bindingImpl.getSource());
                try {
                    bindingImpl.getInternalFactory().get(context, dependency, false);
                }
                catch (InternalProvisionException e) {
                    errors.withSource(dependency).merge(e);
                }
                finally {
                    context.popStateAndSetDependency(previous);
                }
            }
        }
    }

    private boolean isEagerSingleton(InjectorImpl injector, BindingImpl<?> binding, Stage stage) {
        if (binding.getScoping().isEagerSingleton(stage)) {
            return true;
        }
        if (binding instanceof LinkedBindingImpl) {
            Key linkedBinding = ((LinkedBindingImpl)binding).getLinkedKey();
            return this.isEagerSingleton(injector, (BindingImpl<?>)injector.getBinding(linkedBinding), stage);
        }
        return false;
    }

    static class ToolStageInjector
    implements Injector {
        private final Injector delegateInjector;

        ToolStageInjector(Injector delegateInjector) {
            this.delegateInjector = delegateInjector;
        }

        @Override
        public void injectMembers(Object o) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.injectMembers(Object) is not supported in Stage.TOOL");
        }

        @Override
        public Map<Key<?>, Binding<?>> getBindings() {
            return this.delegateInjector.getBindings();
        }

        @Override
        public Map<Key<?>, Binding<?>> getAllBindings() {
            return this.delegateInjector.getAllBindings();
        }

        @Override
        public <T> Binding<T> getBinding(Key<T> key) {
            return this.delegateInjector.getBinding(key);
        }

        @Override
        public <T> Binding<T> getBinding(Class<T> type) {
            return this.delegateInjector.getBinding(type);
        }

        @Override
        public <T> Binding<T> getExistingBinding(Key<T> key) {
            return this.delegateInjector.getExistingBinding(key);
        }

        @Override
        public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
            return this.delegateInjector.findBindingsByType(type);
        }

        @Override
        public Injector getParent() {
            return this.delegateInjector.getParent();
        }

        @Override
        public Injector createChildInjector(Iterable<? extends Module> modules) {
            return this.delegateInjector.createChildInjector(modules);
        }

        @Override
        public Injector createChildInjector(Module ... modules) {
            return this.delegateInjector.createChildInjector(modules);
        }

        @Override
        public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
            return this.delegateInjector.getScopeBindings();
        }

        @Override
        public Set<TypeConverterBinding> getTypeConverterBindings() {
            return this.delegateInjector.getTypeConverterBindings();
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getProvider(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> type) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getProvider(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getMembersInjector(TypeLiteral<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getMembersInjector(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Key<T> key) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getInstance(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Class<T> type) {
            throw new UnsupportedOperationException("io.quarkus.launcher.shaded.Injector.getInstance(Class<T>) is not supported in Stage.TOOL");
        }
    }
}

