/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal;

import io.quarkus.launcher.shaded.com.google.common.base.MoreObjects;
import io.quarkus.launcher.shaded.com.google.common.base.Objects;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.internal.BindingImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.DelayedInitialize;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.internal.ErrorsException;
import io.quarkus.launcher.shaded.com.google.inject.internal.InjectorImpl;
import io.quarkus.launcher.shaded.com.google.inject.internal.InternalFactory;
import io.quarkus.launcher.shaded.com.google.inject.internal.Scoping;
import io.quarkus.launcher.shaded.com.google.inject.spi.BindingTargetVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.HasDependencies;
import io.quarkus.launcher.shaded.com.google.inject.spi.ProviderKeyBinding;
import io.quarkus.launcher.shaded.javax.inject.Provider;
import java.util.Set;

final class LinkedProviderBindingImpl<T>
extends BindingImpl<T>
implements ProviderKeyBinding<T>,
HasDependencies,
DelayedInitialize {
    final Key<? extends Provider<? extends T>> providerKey;
    final DelayedInitialize delayedInitializer;

    private LinkedProviderBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey, DelayedInitialize delayedInitializer) {
        super(injector, key, source, internalFactory, scoping);
        this.providerKey = providerKey;
        this.delayedInitializer = delayedInitializer;
    }

    public LinkedProviderBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        this(injector, key, source, internalFactory, scoping, providerKey, null);
    }

    LinkedProviderBindingImpl(Object source, Key<T> key, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        super(source, key, scoping);
        this.providerKey = providerKey;
        this.delayedInitializer = null;
    }

    static <T> LinkedProviderBindingImpl<T> createWithInitializer(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey, DelayedInitialize delayedInitializer) {
        return new LinkedProviderBindingImpl<T>(injector, key, source, internalFactory, scoping, providerKey, delayedInitializer);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Key<? extends Provider<? extends T>> getProviderKey() {
        return this.providerKey;
    }

    @Override
    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        if (this.delayedInitializer != null) {
            this.delayedInitializer.initialize(injector, errors);
        }
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(this.providerKey));
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new LinkedProviderBindingImpl(this.getSource(), this.getKey(), scoping, this.providerKey);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new LinkedProviderBindingImpl<T>(this.getSource(), key, this.getScoping(), this.providerKey);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(binder.withSource(this.getSource()).bind(this.getKey()).toProvider(this.getProviderKey()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ProviderKeyBinding.class).add("io.quarkus.launcher.shaded.key", this.getKey()).add("io.quarkus.launcher.shaded.source", this.getSource()).add("io.quarkus.launcher.shaded.scope", this.getScoping()).add("io.quarkus.launcher.shaded.provider", this.providerKey).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedProviderBindingImpl) {
            LinkedProviderBindingImpl o = (LinkedProviderBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.providerKey, o.providerKey);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey(), this.getScoping(), this.providerKey);
    }
}

