/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.internal.util;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Classes {
    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    public static String toString(Member member) {
        Class<? extends Member> memberType = Classes.memberType(member);
        if (memberType == Method.class) {
            return member.getDeclaringClass().getName() + "io.quarkus.launcher.shaded.." + member.getName() + "io.quarkus.launcher.shaded.()";
        }
        if (memberType == Field.class) {
            return member.getDeclaringClass().getName() + "io.quarkus.launcher.shaded.." + member.getName();
        }
        if (memberType == Constructor.class) {
            return member.getDeclaringClass().getName() + "io.quarkus.launcher.shaded..<init>()";
        }
        throw new AssertionError();
    }

    public static Class<? extends Member> memberType(Member member) {
        Preconditions.checkNotNull(member, "io.quarkus.launcher.shaded.member");
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("io.quarkus.launcher.shaded.Unsupported implementation class for Member, " + member.getClass());
    }
}

