/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Objects;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.common.collect.Lists;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.internal.MoreTypes;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionPoint;
import java.util.ArrayList;
import java.util.Set;

public final class Dependency<T> {
    private final InjectionPoint injectionPoint;
    private final Key<T> key;
    private final boolean nullable;
    private final int parameterIndex;

    Dependency(InjectionPoint injectionPoint, Key<T> key, boolean nullable, int parameterIndex) {
        this.injectionPoint = injectionPoint;
        this.key = Preconditions.checkNotNull(key, "io.quarkus.launcher.shaded.key");
        this.nullable = nullable;
        this.parameterIndex = parameterIndex;
    }

    public static <T> Dependency<T> get(Key<T> key) {
        return new Dependency<T>(null, MoreTypes.canonicalizeKey(key), true, -1);
    }

    public static Set<Dependency<?>> forInjectionPoints(Set<InjectionPoint> injectionPoints) {
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        for (InjectionPoint injectionPoint : injectionPoints) {
            dependencies.addAll(injectionPoint.getDependencies());
        }
        return ImmutableSet.copyOf(dependencies);
    }

    public Key<T> getKey() {
        return this.key;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public int hashCode() {
        return Objects.hashCode(this.injectionPoint, this.parameterIndex, this.key);
    }

    public boolean equals(Object o) {
        if (o instanceof Dependency) {
            Dependency dependency = (Dependency)o;
            return Objects.equal(this.injectionPoint, dependency.injectionPoint) && Objects.equal(this.parameterIndex, dependency.parameterIndex) && Objects.equal(this.key, dependency.key);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.key);
        if (this.injectionPoint != null) {
            builder.append("io.quarkus.launcher.shaded.@").append(this.injectionPoint);
            if (this.parameterIndex != -1) {
                builder.append("io.quarkus.launcher.shaded.[").append(this.parameterIndex).append("io.quarkus.launcher.shaded.]");
            }
        }
        return builder.toString();
    }
}

