/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.MembersInjector;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;

public final class MembersInjectorLookup<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private MembersInjector<T> delegate;

    public MembersInjectorLookup(Object source, TypeLiteral<T> type) {
        this.source = Preconditions.checkNotNull(source, "io.quarkus.launcher.shaded.source");
        this.type = Preconditions.checkNotNull(type, "io.quarkus.launcher.shaded.type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(MembersInjector<T> delegate) {
        Preconditions.checkState(this.delegate == null, "io.quarkus.launcher.shaded.delegate already initialized");
        this.delegate = Preconditions.checkNotNull(delegate, "io.quarkus.launcher.shaded.delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getMembersInjector(this.type));
    }

    public MembersInjector<T> getDelegate() {
        return this.delegate;
    }

    public MembersInjector<T> getMembersInjector() {
        return new MembersInjector<T>(){

            @Override
            public void injectMembers(T instance) {
                MembersInjector local = MembersInjectorLookup.this.delegate;
                if (local == null) {
                    throw new IllegalStateException("io.quarkus.launcher.shaded.This MembersInjector cannot be used until the Injector has been created.");
                }
                local.injectMembers(instance);
            }

            public String toString() {
                return "io.quarkus.launcher.shaded.MembersInjector<" + MembersInjectorLookup.this.type + "io.quarkus.launcher.shaded.>";
            }
        };
    }
}

