/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ModuleAnnotatedMethodScanner;

public final class ModuleAnnotatedMethodScannerBinding
implements Element {
    private final Object source;
    private final ModuleAnnotatedMethodScanner scanner;

    public ModuleAnnotatedMethodScannerBinding(Object source, ModuleAnnotatedMethodScanner scanner) {
        this.source = Preconditions.checkNotNull(source, "io.quarkus.launcher.shaded.source");
        this.scanner = Preconditions.checkNotNull(scanner, "io.quarkus.launcher.shaded.scanner");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).scanModulesForAnnotatedMethods(this.scanner);
    }

    public String toString() {
        return this.scanner + "io.quarkus.launcher.shaded. which scans for " + this.scanner.annotationClasses() + "io.quarkus.launcher.shaded. (bound at " + Errors.convert(this.source) + "io.quarkus.launcher.shaded.)";
    }
}

